/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.transform.LexiconAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LexiconAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, LexiconAttributes> {
    private final String alphabet;
    private final String languageCode;
    private final Instant lastModified;
    private final String lexiconArn;
    private final Integer lexemesCount;
    private final Integer size;

    private LexiconAttributes(BuilderImpl builder) {
        this.alphabet = builder.alphabet;
        this.languageCode = builder.languageCode;
        this.lastModified = builder.lastModified;
        this.lexiconArn = builder.lexiconArn;
        this.lexemesCount = builder.lexemesCount;
        this.size = builder.size;
    }

    public String alphabet() {
        return this.alphabet;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String lexiconArn() {
        return this.lexiconArn;
    }

    public Integer lexemesCount() {
        return this.lexemesCount;
    }

    public Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alphabet() == null ? 0 : this.alphabet().hashCode());
        hashCode = 31 * hashCode + (this.languageCode() == null ? 0 : this.languageCode().hashCode());
        hashCode = 31 * hashCode + (this.lastModified() == null ? 0 : this.lastModified().hashCode());
        hashCode = 31 * hashCode + (this.lexiconArn() == null ? 0 : this.lexiconArn().hashCode());
        hashCode = 31 * hashCode + (this.lexemesCount() == null ? 0 : this.lexemesCount().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexiconAttributes)) {
            return false;
        }
        LexiconAttributes other = (LexiconAttributes)obj;
        if (other.alphabet() == null ^ this.alphabet() == null) {
            return false;
        }
        if (other.alphabet() != null && !other.alphabet().equals(this.alphabet())) {
            return false;
        }
        if (other.languageCode() == null ^ this.languageCode() == null) {
            return false;
        }
        if (other.languageCode() != null && !other.languageCode().equals(this.languageCode())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        if (other.lexiconArn() == null ^ this.lexiconArn() == null) {
            return false;
        }
        if (other.lexiconArn() != null && !other.lexiconArn().equals(this.lexiconArn())) {
            return false;
        }
        if (other.lexemesCount() == null ^ this.lexemesCount() == null) {
            return false;
        }
        if (other.lexemesCount() != null && !other.lexemesCount().equals(this.lexemesCount())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alphabet() != null) {
            sb.append("Alphabet: ").append(this.alphabet()).append(",");
        }
        if (this.languageCode() != null) {
            sb.append("LanguageCode: ").append(this.languageCode()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.lexiconArn() != null) {
            sb.append("LexiconArn: ").append(this.lexiconArn()).append(",");
        }
        if (this.lexemesCount() != null) {
            sb.append("LexemesCount: ").append(this.lexemesCount()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LexiconAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String alphabet;
        private String languageCode;
        private Instant lastModified;
        private String lexiconArn;
        private Integer lexemesCount;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(LexiconAttributes model) {
            this.setAlphabet(model.alphabet);
            this.setLanguageCode(model.languageCode);
            this.setLastModified(model.lastModified);
            this.setLexiconArn(model.lexiconArn);
            this.setLexemesCount(model.lexemesCount);
            this.setSize(model.size);
        }

        public final String getAlphabet() {
            return this.alphabet;
        }

        @Override
        public final Builder alphabet(String alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        public final void setAlphabet(String alphabet) {
            this.alphabet = alphabet;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLexiconArn() {
            return this.lexiconArn;
        }

        @Override
        public final Builder lexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
            return this;
        }

        public final void setLexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
        }

        public final Integer getLexemesCount() {
            return this.lexemesCount;
        }

        @Override
        public final Builder lexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
            return this;
        }

        public final void setLexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public LexiconAttributes build() {
            return new LexiconAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LexiconAttributes> {
        public Builder alphabet(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lastModified(Instant var1);

        public Builder lexiconArn(String var1);

        public Builder lexemesCount(Integer var1);

        public Builder size(Integer var1);
    }
}

