/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.model.LexiconDescription;

@SdkInternalApi
public class LexiconDescriptionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final LexiconDescriptionMarshaller instance = new LexiconDescriptionMarshaller();

    public static LexiconDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(LexiconDescription lexiconDescription, ProtocolMarshaller protocolMarshaller) {
        if (lexiconDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lexiconDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)lexiconDescription.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

