/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.polly.model.LexiconAttributes;

@SdkInternalApi
public class LexiconAttributesMarshaller {
    private static final MarshallingInfo<String> ALPHABET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alphabet").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final MarshallingInfo<Instant> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").build();
    private static final MarshallingInfo<String> LEXICONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexiconArn").build();
    private static final MarshallingInfo<Integer> LEXEMESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexemesCount").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final LexiconAttributesMarshaller instance = new LexiconAttributesMarshaller();

    public static LexiconAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(LexiconAttributes lexiconAttributes, ProtocolMarshaller protocolMarshaller) {
        if (lexiconAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lexiconAttributes.alphabet(), ALPHABET_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.languageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lexiconArn(), LEXICONARN_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lexemesCount(), LEXEMESCOUNT_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.size(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

