/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.polly.model.Voice;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VoiceMarshaller {
    private static final MarshallingInfo<String> GENDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Gender").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageName").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALLANGUAGECODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalLanguageCodes").isBinary(false).build();
    private static final VoiceMarshaller INSTANCE = new VoiceMarshaller();

    private VoiceMarshaller() {
    }

    public static VoiceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Voice voice, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)voice, (String)"voice");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)voice.genderAsString(), GENDER_BINDING);
            protocolMarshaller.marshall((Object)voice.idAsString(), ID_BINDING);
            protocolMarshaller.marshall((Object)voice.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)voice.languageName(), LANGUAGENAME_BINDING);
            protocolMarshaller.marshall((Object)voice.name(), NAME_BINDING);
            protocolMarshaller.marshall(voice.additionalLanguageCodesAsStrings(), ADDITIONALLANGUAGECODES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

