/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.model.SynthesisTask;

public class SynthesisTaskUnmarshaller
implements Unmarshaller<SynthesisTask, JsonUnmarshallerContext> {
    private static final SynthesisTaskUnmarshaller INSTANCE = new SynthesisTaskUnmarshaller();

    public SynthesisTask unmarshall(JsonUnmarshallerContext context) throws Exception {
        SynthesisTask.Builder synthesisTaskBuilder = SynthesisTask.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TaskId", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.taskId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TaskStatus", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.taskStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TaskStatusReason", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.taskStatusReason((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputUri", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.outputUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestCharacters", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.requestCharacters((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SnsTopicArn", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.snsTopicArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LexiconNames", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.lexiconNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("OutputFormat", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.outputFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SampleRate", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.sampleRate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SpeechMarkTypes", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.speechMarkTypesWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("TextType", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.textType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VoiceId", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.voiceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LanguageCode", targetDepth)) {
                    context.nextToken();
                    synthesisTaskBuilder.languageCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SynthesisTask)synthesisTaskBuilder.build();
    }

    public static SynthesisTaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

