/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.polly.model.SynthesisTask;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SynthesisTaskMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskId").isBinary(false).build();
    private static final MarshallingInfo<String> TASKSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskStatus").isBinary(false).build();
    private static final MarshallingInfo<String> TASKSTATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskStatusReason").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUri").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> REQUESTCHARACTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestCharacters").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").isBinary(false).build();
    private static final MarshallingInfo<List> LEXICONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexiconNames").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").isBinary(false).build();
    private static final MarshallingInfo<String> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleRate").isBinary(false).build();
    private static final MarshallingInfo<List> SPEECHMARKTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpeechMarkTypes").isBinary(false).build();
    private static final MarshallingInfo<String> TEXTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextType").isBinary(false).build();
    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VoiceId").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final SynthesisTaskMarshaller INSTANCE = new SynthesisTaskMarshaller();

    private SynthesisTaskMarshaller() {
    }

    public static SynthesisTaskMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SynthesisTask synthesisTask, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)synthesisTask, (String)"synthesisTask");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)synthesisTask.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.taskStatusAsString(), TASKSTATUS_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.taskStatusReason(), TASKSTATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.outputUri(), OUTPUTURI_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.requestCharacters(), REQUESTCHARACTERS_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(synthesisTask.lexiconNames(), LEXICONNAMES_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.outputFormatAsString(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall(synthesisTask.speechMarkTypesAsStrings(), SPEECHMARKTYPES_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.textTypeAsString(), TEXTTYPE_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.voiceIdAsString(), VOICEID_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.languageCodeAsString(), LANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

