/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.polly.model.LexiconDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LexiconDescriptionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final LexiconDescriptionMarshaller INSTANCE = new LexiconDescriptionMarshaller();

    private LexiconDescriptionMarshaller() {
    }

    public static LexiconDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LexiconDescription lexiconDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lexiconDescription, (String)"lexiconDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lexiconDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)lexiconDescription.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

