/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.polly.model.LexiconAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LexiconAttributesMarshaller {
    private static final MarshallingInfo<String> ALPHABET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alphabet").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").isBinary(false).build();
    private static final MarshallingInfo<String> LEXICONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexiconArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> LEXEMESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexemesCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final LexiconAttributesMarshaller INSTANCE = new LexiconAttributesMarshaller();

    private LexiconAttributesMarshaller() {
    }

    public static LexiconAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LexiconAttributes lexiconAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lexiconAttributes, (String)"lexiconAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lexiconAttributes.alphabet(), ALPHABET_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lexiconArn(), LEXICONARN_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.lexemesCount(), LEXEMESCOUNT_BINDING);
            protocolMarshaller.marshall((Object)lexiconAttributes.size(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

