/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.Gender;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LanguageCodeListCopier;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.services.polly.transform.VoiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Voice
implements StructuredPojo,
ToCopyableBuilder<Builder, Voice> {
    private final String gender;
    private final String id;
    private final String languageCode;
    private final String languageName;
    private final String name;
    private final List<String> additionalLanguageCodes;

    private Voice(BuilderImpl builder) {
        this.gender = builder.gender;
        this.id = builder.id;
        this.languageCode = builder.languageCode;
        this.languageName = builder.languageName;
        this.name = builder.name;
        this.additionalLanguageCodes = builder.additionalLanguageCodes;
    }

    public Gender gender() {
        return Gender.fromValue(this.gender);
    }

    public String genderAsString() {
        return this.gender;
    }

    public VoiceId id() {
        return VoiceId.fromValue(this.id);
    }

    public String idAsString() {
        return this.id;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String languageName() {
        return this.languageName;
    }

    public String name() {
        return this.name;
    }

    public List<LanguageCode> additionalLanguageCodes() {
        return TypeConverter.convert(this.additionalLanguageCodes, LanguageCode::fromValue);
    }

    public List<String> additionalLanguageCodesAsStrings() {
        return this.additionalLanguageCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalLanguageCodesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Voice)) {
            return false;
        }
        Voice other = (Voice)obj;
        return Objects.equals(this.genderAsString(), other.genderAsString()) && Objects.equals(this.idAsString(), other.idAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageName(), other.languageName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.additionalLanguageCodesAsStrings(), other.additionalLanguageCodesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Voice").add("Gender", (Object)this.genderAsString()).add("Id", (Object)this.idAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageName", (Object)this.languageName()).add("Name", (Object)this.name()).add("AdditionalLanguageCodes", this.additionalLanguageCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gender": {
                return Optional.ofNullable(clazz.cast(this.genderAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.idAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageName": {
                return Optional.ofNullable(clazz.cast(this.languageName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AdditionalLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.additionalLanguageCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VoiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String gender;
        private String id;
        private String languageCode;
        private String languageName;
        private String name;
        private List<String> additionalLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Voice model) {
            this.gender(model.gender);
            this.id(model.id);
            this.languageCode(model.languageCode);
            this.languageName(model.languageName);
            this.name(model.name);
            this.additionalLanguageCodesWithStrings(model.additionalLanguageCodes);
        }

        public final String getGender() {
            return this.gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender.toString());
            return this;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder id(VoiceId id) {
            this.id(id.toString());
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageName() {
            return this.languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getAdditionalLanguageCodes() {
            return this.additionalLanguageCodes;
        }

        @Override
        public final Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodesWithStrings(String ... additionalLanguageCodes) {
            this.additionalLanguageCodesWithStrings(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        @Override
        public final Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copyEnumToString(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodes(LanguageCode ... additionalLanguageCodes) {
            this.additionalLanguageCodes(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        public final void setAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
        }

        public Voice build() {
            return new Voice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Voice> {
        public Builder gender(String var1);

        public Builder gender(Gender var1);

        public Builder id(String var1);

        public Builder id(VoiceId var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageName(String var1);

        public Builder name(String var1);

        public Builder additionalLanguageCodesWithStrings(Collection<String> var1);

        public Builder additionalLanguageCodesWithStrings(String ... var1);

        public Builder additionalLanguageCodes(Collection<LanguageCode> var1);

        public Builder additionalLanguageCodes(LanguageCode ... var1);
    }
}

