/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TaskStatus;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.services.polly.transform.SynthesisTaskMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SynthesisTask
implements StructuredPojo,
ToCopyableBuilder<Builder, SynthesisTask> {
    private final String taskId;
    private final String taskStatus;
    private final String taskStatusReason;
    private final String outputUri;
    private final Instant creationTime;
    private final Integer requestCharacters;
    private final String snsTopicArn;
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String sampleRate;
    private final List<String> speechMarkTypes;
    private final String textType;
    private final String voiceId;
    private final String languageCode;

    private SynthesisTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.taskStatusReason = builder.taskStatusReason;
        this.outputUri = builder.outputUri;
        this.creationTime = builder.creationTime;
        this.requestCharacters = builder.requestCharacters;
        this.snsTopicArn = builder.snsTopicArn;
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.sampleRate = builder.sampleRate;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
        this.languageCode = builder.languageCode;
    }

    public String taskId() {
        return this.taskId;
    }

    public TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public String taskStatusAsString() {
        return this.taskStatus;
    }

    public String taskStatusReason() {
        return this.taskStatusReason;
    }

    public String outputUri() {
        return this.outputUri;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Integer requestCharacters() {
        return this.requestCharacters;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public String outputFormatAsString() {
        return this.outputFormat;
    }

    public String sampleRate() {
        return this.sampleRate;
    }

    public List<SpeechMarkType> speechMarkTypes() {
        return TypeConverter.convert(this.speechMarkTypes, SpeechMarkType::fromValue);
    }

    public List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public String textTypeAsString() {
        return this.textType;
    }

    public VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public String voiceIdAsString() {
        return this.voiceId;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexiconNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechMarkTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesisTask)) {
            return false;
        }
        SynthesisTask other = (SynthesisTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.taskStatusReason(), other.taskStatusReason()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.requestCharacters(), other.requestCharacters()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"SynthesisTask").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("TaskStatusReason", (Object)this.taskStatusReason()).add("OutputUri", (Object)this.outputUri()).add("CreationTime", (Object)this.creationTime()).add("RequestCharacters", (Object)this.requestCharacters()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("LexiconNames", this.lexiconNames()).add("OutputFormat", (Object)this.outputFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("SpeechMarkTypes", this.speechMarkTypesAsStrings()).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "TaskStatusReason": {
                return Optional.ofNullable(clazz.cast(this.taskStatusReason()));
            }
            case "OutputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "RequestCharacters": {
                return Optional.ofNullable(clazz.cast(this.requestCharacters()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "LexiconNames": {
                return Optional.ofNullable(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SpeechMarkTypes": {
                return Optional.ofNullable(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SynthesisTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String taskStatusReason;
        private String outputUri;
        private Instant creationTime;
        private Integer requestCharacters;
        private String snsTopicArn;
        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;
        private String sampleRate;
        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();
        private String textType;
        private String voiceId;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesisTask model) {
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.taskStatusReason(model.taskStatusReason);
            this.outputUri(model.outputUri);
            this.creationTime(model.creationTime);
            this.requestCharacters(model.requestCharacters);
            this.snsTopicArn(model.snsTopicArn);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.sampleRate(model.sampleRate);
            this.speechMarkTypesWithStrings(model.speechMarkTypes);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
            this.languageCode(model.languageCode);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getTaskStatusReason() {
            return this.taskStatusReason;
        }

        @Override
        public final Builder taskStatusReason(String taskStatusReason) {
            this.taskStatusReason = taskStatusReason;
            return this;
        }

        public final void setTaskStatusReason(String taskStatusReason) {
            this.taskStatusReason = taskStatusReason;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRequestCharacters() {
            return this.requestCharacters;
        }

        @Override
        public final Builder requestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
            return this;
        }

        public final void setRequestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getLexiconNames() {
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Collection<String> getSpeechMarkTypes() {
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String ... speechMarkTypes) {
            this.speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public SynthesisTask build() {
            return new SynthesisTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SynthesisTask> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder taskStatusReason(String var1);

        public Builder outputUri(String var1);

        public Builder creationTime(Instant var1);

        public Builder requestCharacters(Integer var1);

        public Builder snsTopicArn(String var1);

        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder sampleRate(String var1);

        public Builder speechMarkTypesWithStrings(Collection<String> var1);

        public Builder speechMarkTypesWithStrings(String ... var1);

        public Builder speechMarkTypes(Collection<SpeechMarkType> var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);
    }
}

