/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSpeechSynthesisTaskRequest
extends PollyRequest
implements ToCopyableBuilder<Builder, StartSpeechSynthesisTaskRequest> {
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String sampleRate;
    private final String snsTopicArn;
    private final List<String> speechMarkTypes;
    private final String text;
    private final String textType;
    private final String voiceId;
    private final String languageCode;

    private StartSpeechSynthesisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.sampleRate = builder.sampleRate;
        this.snsTopicArn = builder.snsTopicArn;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
        this.languageCode = builder.languageCode;
    }

    public List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public String outputFormatAsString() {
        return this.outputFormat;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public String sampleRate() {
        return this.sampleRate;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public List<SpeechMarkType> speechMarkTypes() {
        return TypeConverter.convert(this.speechMarkTypes, SpeechMarkType::fromValue);
    }

    public List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public String text() {
        return this.text;
    }

    public TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public String textTypeAsString() {
        return this.textType;
    }

    public VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public String voiceIdAsString() {
        return this.voiceId;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lexiconNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechMarkTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeechSynthesisTaskRequest)) {
            return false;
        }
        StartSpeechSynthesisTaskRequest other = (StartSpeechSynthesisTaskRequest)((Object)obj);
        return Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StartSpeechSynthesisTaskRequest").add("LexiconNames", this.lexiconNames()).add("OutputFormat", (Object)this.outputFormatAsString()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("SampleRate", (Object)this.sampleRate()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SpeechMarkTypes", this.speechMarkTypesAsStrings()).add("Text", (Object)this.text()).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LexiconNames": {
                return Optional.ofNullable(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SpeechMarkTypes": {
                return Optional.ofNullable(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PollyRequest.BuilderImpl
    implements Builder {
        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String sampleRate;
        private String snsTopicArn;
        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();
        private String text;
        private String textType;
        private String voiceId;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeechSynthesisTaskRequest model) {
            super(model);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.sampleRate(model.sampleRate);
            this.snsTopicArn(model.snsTopicArn);
            this.speechMarkTypesWithStrings(model.speechMarkTypes);
            this.text(model.text);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
            this.languageCode(model.languageCode);
        }

        public final Collection<String> getLexiconNames() {
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getSpeechMarkTypes() {
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String ... speechMarkTypes) {
            this.speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeechSynthesisTaskRequest build() {
            return new StartSpeechSynthesisTaskRequest(this);
        }
    }

    public static interface Builder
    extends PollyRequest.Builder,
    CopyableBuilder<Builder, StartSpeechSynthesisTaskRequest> {
        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder sampleRate(String var1);

        public Builder snsTopicArn(String var1);

        public Builder speechMarkTypesWithStrings(Collection<String> var1);

        public Builder speechMarkTypesWithStrings(String ... var1);

        public Builder speechMarkTypes(Collection<SpeechMarkType> var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

