/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.PollyAsyncClient;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidS3BucketException;
import software.amazon.awssdk.services.polly.model.InvalidS3KeyException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.InvalidTaskIdException;
import software.amazon.awssdk.services.polly.model.LanguageNotSupportedException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTaskNotFoundException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.GetSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetSpeechSynthesisTaskResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.ListSpeechSynthesisTasksRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListSpeechSynthesisTasksResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.StartSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.StartSpeechSynthesisTaskResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
final class DefaultPollyAsyncClient
implements PollyAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPollyAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultPollyAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "polly";
    }

    @Override
    public CompletableFuture<DeleteLexiconResponse> deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLexiconResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLexiconRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeVoicesResponse> describeVoices(DescribeVoicesRequest describeVoicesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVoicesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeVoicesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVoicesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLexiconResponse> getLexicon(GetLexiconRequest getLexiconRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLexiconResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLexiconRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSpeechSynthesisTaskResponse> getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSpeechSynthesisTaskResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSpeechSynthesisTaskRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSpeechSynthesisTaskRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLexiconsResponse> listLexicons(ListLexiconsRequest listLexiconsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLexiconsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListLexiconsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLexiconsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSpeechSynthesisTasksResponse> listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSpeechSynthesisTasksResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListSpeechSynthesisTasksRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSpeechSynthesisTasksRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLexiconResponse> putLexicon(PutLexiconRequest putLexiconRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLexiconResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLexiconRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSpeechSynthesisTaskResponse> startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSpeechSynthesisTaskResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartSpeechSynthesisTaskRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSpeechSynthesisTaskRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, AsyncResponseTransformer<SynthesizeSpeechResponse, ReturnT> asyncResponseTransformer) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new SynthesizeSpeechResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SynthesizeSpeechRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)synthesizeSpeechRequest), asyncResponseTransformer).whenComplete((r, e) -> {
                if (e != null) {
                    asyncResponseTransformer.exceptionOccurred(e);
                }
            });
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseTransformer.exceptionOccurred(t));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(PollyException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3BucketException").withModeledClass(InvalidS3BucketException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSampleRateException").withModeledClass(InvalidSampleRateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SynthesisTaskNotFoundException").withModeledClass(SynthesisTaskNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexiconsNumberExceededException").withModeledClass(MaxLexiconsNumberExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexemeLengthExceededException").withModeledClass(MaxLexemeLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsAlphabetException").withModeledClass(UnsupportedPlsAlphabetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LanguageNotSupportedException").withModeledClass(LanguageNotSupportedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextLengthExceededException").withModeledClass(TextLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLexiconException").withModeledClass(InvalidLexiconException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SsmlMarksNotSupportedForTextTypeException").withModeledClass(SsmlMarksNotSupportedForTextTypeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3KeyException").withModeledClass(InvalidS3KeyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSnsTopicArnException").withModeledClass(InvalidSnsTopicArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarksNotSupportedForFormatException").withModeledClass(MarksNotSupportedForFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTaskIdException").withModeledClass(InvalidTaskIdException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsLanguageException").withModeledClass(UnsupportedPlsLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconNotFoundException").withModeledClass(LexiconNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconSizeExceededException").withModeledClass(LexiconSizeExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSsmlException").withModeledClass(InvalidSsmlException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withModeledClass(ServiceFailureException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

