/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SynthesizeSpeechRequestModelMarshaller {
    private static final MarshallingInfo<List> LEXICONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexiconNames").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").isBinary(false).build();
    private static final MarshallingInfo<String> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleRate").isBinary(false).build();
    private static final MarshallingInfo<List> SPEECHMARKTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpeechMarkTypes").isBinary(false).build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<String> TEXTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextType").isBinary(false).build();
    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VoiceId").isBinary(false).build();
    private static final SynthesizeSpeechRequestModelMarshaller INSTANCE = new SynthesizeSpeechRequestModelMarshaller();

    private SynthesizeSpeechRequestModelMarshaller() {
    }

    public static SynthesizeSpeechRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SynthesizeSpeechRequest synthesizeSpeechRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)synthesizeSpeechRequest), (String)"synthesizeSpeechRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(synthesizeSpeechRequest.lexiconNames(), LEXICONNAMES_BINDING);
            protocolMarshaller.marshall((Object)synthesizeSpeechRequest.outputFormatAsString(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)synthesizeSpeechRequest.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall(synthesizeSpeechRequest.speechMarkTypesAsStrings(), SPEECHMARKTYPES_BINDING);
            protocolMarshaller.marshall((Object)synthesizeSpeechRequest.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)synthesizeSpeechRequest.textTypeAsString(), TEXTTYPE_BINDING);
            protocolMarshaller.marshall((Object)synthesizeSpeechRequest.voiceIdAsString(), VOICEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

