/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SynthesizeSpeechRequest
extends PollyRequest
implements ToCopyableBuilder<Builder, SynthesizeSpeechRequest> {
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String sampleRate;
    private final List<String> speechMarkTypes;
    private final String text;
    private final String textType;
    private final String voiceId;

    private SynthesizeSpeechRequest(BuilderImpl builder) {
        super(builder);
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.sampleRate = builder.sampleRate;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
    }

    public List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public String outputFormatAsString() {
        return this.outputFormat;
    }

    public String sampleRate() {
        return this.sampleRate;
    }

    public List<SpeechMarkType> speechMarkTypes() {
        return TypeConverter.convert(this.speechMarkTypes, SpeechMarkType::fromValue);
    }

    public List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public String text() {
        return this.text;
    }

    public TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public String textTypeAsString() {
        return this.textType;
    }

    public VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public String voiceIdAsString() {
        return this.voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lexiconNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechMarkTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesizeSpeechRequest)) {
            return false;
        }
        SynthesizeSpeechRequest other = (SynthesizeSpeechRequest)((Object)obj);
        return Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString());
    }

    public String toString() {
        return ToString.builder((String)"SynthesizeSpeechRequest").add("LexiconNames", this.lexiconNames()).add("OutputFormat", (Object)this.outputFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("SpeechMarkTypes", this.speechMarkTypesAsStrings()).add("Text", (Object)this.text()).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LexiconNames": {
                return Optional.of(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.of(clazz.cast(this.outputFormatAsString()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
            case "SpeechMarkTypes": {
                return Optional.of(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "Text": {
                return Optional.of(clazz.cast(this.text()));
            }
            case "TextType": {
                return Optional.of(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.of(clazz.cast(this.voiceIdAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PollyRequest.BuilderImpl
    implements Builder {
        private List<String> lexiconNames;
        private String outputFormat;
        private String sampleRate;
        private List<String> speechMarkTypes;
        private String text;
        private String textType;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesizeSpeechRequest model) {
            super(model);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.sampleRate(model.sampleRate);
            this.speechMarkTypes(model.speechMarkTypes);
            this.text(model.text);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
        }

        public final Collection<String> getLexiconNames() {
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Collection<String> getSpeechMarkTypes() {
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(String ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SynthesizeSpeechRequest build() {
            return new SynthesizeSpeechRequest(this);
        }
    }

    public static interface Builder
    extends PollyRequest.Builder,
    CopyableBuilder<Builder, SynthesizeSpeechRequest> {
        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder sampleRate(String var1);

        public Builder speechMarkTypes(Collection<String> var1);

        public Builder speechMarkTypes(String ... var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

