/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.polly.model.LexiconDescription;
import software.amazon.awssdk.services.polly.model.LexiconDescriptionListCopier;
import software.amazon.awssdk.services.polly.model.PollyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLexiconsResponse
extends PollyResponse
implements ToCopyableBuilder<Builder, ListLexiconsResponse> {
    private final List<LexiconDescription> lexicons;
    private final String nextToken;

    private ListLexiconsResponse(BuilderImpl builder) {
        super(builder);
        this.lexicons = builder.lexicons;
        this.nextToken = builder.nextToken;
    }

    public List<LexiconDescription> lexicons() {
        return this.lexicons;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lexicons());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLexiconsResponse)) {
            return false;
        }
        ListLexiconsResponse other = (ListLexiconsResponse)((Object)obj);
        return Objects.equals(this.lexicons(), other.lexicons()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLexiconsResponse").add("Lexicons", this.lexicons()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Lexicons": {
                return Optional.of(clazz.cast(this.lexicons()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PollyResponse.BuilderImpl
    implements Builder {
        private List<LexiconDescription> lexicons;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLexiconsResponse model) {
            super(model);
            this.lexicons(model.lexicons);
            this.nextToken(model.nextToken);
        }

        public final Collection<LexiconDescription.Builder> getLexicons() {
            return this.lexicons != null ? (Collection)this.lexicons.stream().map(LexiconDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lexicons(Collection<LexiconDescription> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copy(lexicons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexicons(LexiconDescription ... lexicons) {
            this.lexicons(Arrays.asList(lexicons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexicons(Consumer<LexiconDescription.Builder> ... lexicons) {
            this.lexicons(Stream.of(lexicons).map(c -> (LexiconDescription)((LexiconDescription.Builder)LexiconDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLexicons(Collection<LexiconDescription.BuilderImpl> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copyFromBuilder(lexicons);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLexiconsResponse build() {
            return new ListLexiconsResponse(this);
        }
    }

    public static interface Builder
    extends PollyResponse.Builder,
    CopyableBuilder<Builder, ListLexiconsResponse> {
        public Builder lexicons(Collection<LexiconDescription> var1);

        public Builder lexicons(LexiconDescription ... var1);

        public Builder lexicons(Consumer<LexiconDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

