/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SynthesizeSpeechRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SynthesizeSpeechRequest> {
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String sampleRate;
    private final List<String> speechMarkTypes;
    private final String text;
    private final String textType;
    private final String voiceId;

    private SynthesizeSpeechRequest(BuilderImpl builder) {
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.sampleRate = builder.sampleRate;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
    }

    public List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public String sampleRate() {
        return this.sampleRate;
    }

    public List<String> speechMarkTypes() {
        return this.speechMarkTypes;
    }

    public String text() {
        return this.text;
    }

    public String textType() {
        return this.textType;
    }

    public String voiceId() {
        return this.voiceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lexiconNames() == null ? 0 : this.lexiconNames().hashCode());
        hashCode = 31 * hashCode + (this.outputFormat() == null ? 0 : this.outputFormat().hashCode());
        hashCode = 31 * hashCode + (this.sampleRate() == null ? 0 : this.sampleRate().hashCode());
        hashCode = 31 * hashCode + (this.speechMarkTypes() == null ? 0 : this.speechMarkTypes().hashCode());
        hashCode = 31 * hashCode + (this.text() == null ? 0 : this.text().hashCode());
        hashCode = 31 * hashCode + (this.textType() == null ? 0 : this.textType().hashCode());
        hashCode = 31 * hashCode + (this.voiceId() == null ? 0 : this.voiceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesizeSpeechRequest)) {
            return false;
        }
        SynthesizeSpeechRequest other = (SynthesizeSpeechRequest)((Object)obj);
        if (other.lexiconNames() == null ^ this.lexiconNames() == null) {
            return false;
        }
        if (other.lexiconNames() != null && !other.lexiconNames().equals(this.lexiconNames())) {
            return false;
        }
        if (other.outputFormat() == null ^ this.outputFormat() == null) {
            return false;
        }
        if (other.outputFormat() != null && !other.outputFormat().equals(this.outputFormat())) {
            return false;
        }
        if (other.sampleRate() == null ^ this.sampleRate() == null) {
            return false;
        }
        if (other.sampleRate() != null && !other.sampleRate().equals(this.sampleRate())) {
            return false;
        }
        if (other.speechMarkTypes() == null ^ this.speechMarkTypes() == null) {
            return false;
        }
        if (other.speechMarkTypes() != null && !other.speechMarkTypes().equals(this.speechMarkTypes())) {
            return false;
        }
        if (other.text() == null ^ this.text() == null) {
            return false;
        }
        if (other.text() != null && !other.text().equals(this.text())) {
            return false;
        }
        if (other.textType() == null ^ this.textType() == null) {
            return false;
        }
        if (other.textType() != null && !other.textType().equals(this.textType())) {
            return false;
        }
        if (other.voiceId() == null ^ this.voiceId() == null) {
            return false;
        }
        return other.voiceId() == null || other.voiceId().equals(this.voiceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lexiconNames() != null) {
            sb.append("LexiconNames: ").append(this.lexiconNames()).append(",");
        }
        if (this.outputFormat() != null) {
            sb.append("OutputFormat: ").append(this.outputFormat()).append(",");
        }
        if (this.sampleRate() != null) {
            sb.append("SampleRate: ").append(this.sampleRate()).append(",");
        }
        if (this.speechMarkTypes() != null) {
            sb.append("SpeechMarkTypes: ").append(this.speechMarkTypes()).append(",");
        }
        if (this.text() != null) {
            sb.append("Text: ").append(this.text()).append(",");
        }
        if (this.textType() != null) {
            sb.append("TextType: ").append(this.textType()).append(",");
        }
        if (this.voiceId() != null) {
            sb.append("VoiceId: ").append(this.voiceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> lexiconNames;
        private String outputFormat;
        private String sampleRate;
        private List<String> speechMarkTypes;
        private String text;
        private String textType;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesizeSpeechRequest model) {
            this.setLexiconNames(model.lexiconNames);
            this.setOutputFormat(model.outputFormat);
            this.setSampleRate(model.sampleRate);
            this.setSpeechMarkTypes(model.speechMarkTypes);
            this.setText(model.text);
            this.setTextType(model.textType);
            this.setVoiceId(model.voiceId);
        }

        public final Collection<String> getLexiconNames() {
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            if (this.lexiconNames == null) {
                this.lexiconNames = new ArrayList<String>(lexiconNames.length);
            }
            for (String e : lexiconNames) {
                this.lexiconNames.add(e);
            }
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        @SafeVarargs
        public final void setLexiconNames(String ... lexiconNames) {
            if (this.lexiconNames == null) {
                this.lexiconNames = new ArrayList<String>(lexiconNames.length);
            }
            for (String e : lexiconNames) {
                this.lexiconNames.add(e);
            }
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final void setOutputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat.toString());
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Collection<String> getSpeechMarkTypes() {
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(String ... speechMarkTypes) {
            if (this.speechMarkTypes == null) {
                this.speechMarkTypes = new ArrayList<String>(speechMarkTypes.length);
            }
            for (String e : speechMarkTypes) {
                this.speechMarkTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            if (this.speechMarkTypes == null) {
                this.speechMarkTypes = new ArrayList<String>(speechMarkTypes.length);
            }
            for (SpeechMarkType ele : speechMarkTypes) {
                this.speechMarkTypes.add(ele.toString());
            }
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        @SafeVarargs
        public final void setSpeechMarkTypes(String ... speechMarkTypes) {
            if (this.speechMarkTypes == null) {
                this.speechMarkTypes = new ArrayList<String>(speechMarkTypes.length);
            }
            for (String e : speechMarkTypes) {
                this.speechMarkTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setSpeechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            if (this.speechMarkTypes == null) {
                this.speechMarkTypes = new ArrayList<String>(speechMarkTypes.length);
            }
            for (SpeechMarkType ele : speechMarkTypes) {
                this.speechMarkTypes.add(ele.toString());
            }
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final void setTextType(TextType textType) {
            this.textType(textType.toString());
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final void setVoiceId(VoiceId voiceId) {
            this.voiceId(voiceId.toString());
        }

        public SynthesizeSpeechRequest build() {
            return new SynthesizeSpeechRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SynthesizeSpeechRequest> {
        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder sampleRate(String var1);

        public Builder speechMarkTypes(Collection<String> var1);

        public Builder speechMarkTypes(String ... var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);
    }
}

