/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum OutputFormat {
    Json("json"),
    Mp3("mp3"),
    Ogg_vorbis("ogg_vorbis"),
    Pcm("pcm");

    private final String value;

    private OutputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static OutputFormat fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(OutputFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

