/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.polly.model.LexiconDescription;
import software.amazon.awssdk.services.polly.model.LexiconDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLexiconsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListLexiconsResponse> {
    private final List<LexiconDescription> lexicons;
    private final String nextToken;

    private ListLexiconsResponse(BuilderImpl builder) {
        this.lexicons = builder.lexicons;
        this.nextToken = builder.nextToken;
    }

    public List<LexiconDescription> lexicons() {
        return this.lexicons;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lexicons() == null ? 0 : this.lexicons().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLexiconsResponse)) {
            return false;
        }
        ListLexiconsResponse other = (ListLexiconsResponse)((Object)obj);
        if (other.lexicons() == null ^ this.lexicons() == null) {
            return false;
        }
        if (other.lexicons() != null && !other.lexicons().equals(this.lexicons())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lexicons() != null) {
            sb.append("Lexicons: ").append(this.lexicons()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LexiconDescription> lexicons;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLexiconsResponse model) {
            this.setLexicons(model.lexicons);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LexiconDescription> getLexicons() {
            return this.lexicons;
        }

        @Override
        public final Builder lexicons(Collection<LexiconDescription> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copy(lexicons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexicons(LexiconDescription ... lexicons) {
            if (this.lexicons == null) {
                this.lexicons = new ArrayList<LexiconDescription>(lexicons.length);
            }
            for (LexiconDescription e : lexicons) {
                this.lexicons.add(e);
            }
            return this;
        }

        public final void setLexicons(Collection<LexiconDescription> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copy(lexicons);
        }

        @SafeVarargs
        public final void setLexicons(LexiconDescription ... lexicons) {
            if (this.lexicons == null) {
                this.lexicons = new ArrayList<LexiconDescription>(lexicons.length);
            }
            for (LexiconDescription e : lexicons) {
                this.lexicons.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListLexiconsResponse build() {
            return new ListLexiconsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListLexiconsResponse> {
        public Builder lexicons(Collection<LexiconDescription> var1);

        public Builder lexicons(LexiconDescription ... var1);

        public Builder nextToken(String var1);
    }
}

