/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.polly.model.Voice;
import software.amazon.awssdk.services.polly.model.VoiceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVoicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVoicesResponse> {
    private final List<Voice> voices;
    private final String nextToken;

    private DescribeVoicesResponse(BuilderImpl builder) {
        this.voices = builder.voices;
        this.nextToken = builder.nextToken;
    }

    public List<Voice> voices() {
        return this.voices;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.voices() == null ? 0 : this.voices().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesResponse)) {
            return false;
        }
        DescribeVoicesResponse other = (DescribeVoicesResponse)((Object)obj);
        if (other.voices() == null ^ this.voices() == null) {
            return false;
        }
        if (other.voices() != null && !other.voices().equals(this.voices())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.voices() != null) {
            sb.append("Voices: ").append(this.voices()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Voice> voices;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesResponse model) {
            this.setVoices(model.voices);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Voice> getVoices() {
            return this.voices;
        }

        @Override
        public final Builder voices(Collection<Voice> voices) {
            this.voices = VoiceListCopier.copy(voices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Voice ... voices) {
            if (this.voices == null) {
                this.voices = new ArrayList<Voice>(voices.length);
            }
            for (Voice e : voices) {
                this.voices.add(e);
            }
            return this;
        }

        public final void setVoices(Collection<Voice> voices) {
            this.voices = VoiceListCopier.copy(voices);
        }

        @SafeVarargs
        public final void setVoices(Voice ... voices) {
            if (this.voices == null) {
                this.voices = new ArrayList<Voice>(voices.length);
            }
            for (Voice e : voices) {
                this.voices.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeVoicesResponse build() {
            return new DescribeVoicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVoicesResponse> {
        public Builder voices(Collection<Voice> var1);

        public Builder voices(Voice ... var1);

        public Builder nextToken(String var1);
    }
}

