/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.PollyAsyncClient;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechResponseUnmarshaller;

@SdkInternalApi
final class DefaultPollyAsyncClient
implements PollyAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultPollyAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<DeleteLexiconResponse> deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteLexiconRequest));
    }

    @Override
    public CompletableFuture<DescribeVoicesResponse> describeVoices(DescribeVoicesRequest describeVoicesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeVoicesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeVoicesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeVoicesRequest));
    }

    @Override
    public CompletableFuture<GetLexiconResponse> getLexicon(GetLexiconRequest getLexiconRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getLexiconRequest));
    }

    @Override
    public CompletableFuture<ListLexiconsResponse> listLexicons(ListLexiconsRequest listLexiconsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListLexiconsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListLexiconsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listLexiconsRequest));
    }

    @Override
    public CompletableFuture<PutLexiconResponse> putLexicon(PutLexiconRequest putLexiconRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutLexiconRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putLexiconRequest));
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, AsyncResponseHandler<SynthesizeSpeechResponse, ReturnT> asyncResponseHandler) {
        SdkHttpResponseHandler responseHandler = this.protocolFactory.createAsyncStreamingResponseHandler((Unmarshaller)new SynthesizeSpeechResponseUnmarshaller(), asyncResponseHandler);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SynthesizeSpeechRequestMarshaller(this.protocolFactory)).withAsyncResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)synthesizeSpeechRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(PollyException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSampleRateException").withModeledClass(InvalidSampleRateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexiconsNumberExceededException").withModeledClass(MaxLexiconsNumberExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarksNotSupportedForFormatException").withModeledClass(MarksNotSupportedForFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexemeLengthExceededException").withModeledClass(MaxLexemeLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsLanguageException").withModeledClass(UnsupportedPlsLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsAlphabetException").withModeledClass(UnsupportedPlsAlphabetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextLengthExceededException").withModeledClass(TextLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconNotFoundException").withModeledClass(LexiconNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconSizeExceededException").withModeledClass(LexiconSizeExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLexiconException").withModeledClass(InvalidLexiconException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSsmlException").withModeledClass(InvalidSsmlException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withModeledClass(ServiceFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SsmlMarksNotSupportedForTextTypeException").withModeledClass(SsmlMarksNotSupportedForTextTypeException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

