/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using an MSK stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipeSourceManagedStreamingKafkaParameters
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<UpdatePipeSourceManagedStreamingKafkaParameters.Builder, UpdatePipeSourceManagedStreamingKafkaParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(UpdatePipeSourceManagedStreamingKafkaParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<MSKAccessCredentials> CREDENTIALS_FIELD = SdkField
            .<MSKAccessCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(UpdatePipeSourceManagedStreamingKafkaParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(MSKAccessCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(UpdatePipeSourceManagedStreamingKafkaParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD,
            CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer batchSize;

    private final MSKAccessCredentials credentials;

    private final Integer maximumBatchingWindowInSeconds;

    private UpdatePipeSourceManagedStreamingKafkaParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The credentials needed to access the resource.
     * </p>
     * 
     * @return The credentials needed to access the resource.
     */
    public final MSKAccessCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceManagedStreamingKafkaParameters)) {
            return false;
        }
        UpdatePipeSourceManagedStreamingKafkaParameters other = (UpdatePipeSourceManagedStreamingKafkaParameters) obj;
        return Objects.equals(batchSize(), other.batchSize()) && Objects.equals(credentials(), other.credentials())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipeSourceManagedStreamingKafkaParameters").add("BatchSize", batchSize())
                .add("Credentials", credentials()).add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceManagedStreamingKafkaParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceManagedStreamingKafkaParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePipeSourceManagedStreamingKafkaParameters> {
        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * 
         * @param credentials
         *        The credentials needed to access the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(MSKAccessCredentials credentials);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link MSKAccessCredentials.Builder} avoiding
         * the need to create one manually via {@link MSKAccessCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MSKAccessCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(MSKAccessCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link MSKAccessCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(MSKAccessCredentials)
         */
        default Builder credentials(Consumer<MSKAccessCredentials.Builder> credentials) {
            return credentials(MSKAccessCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer batchSize;

        private MSKAccessCredentials credentials;

        private Integer maximumBatchingWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceManagedStreamingKafkaParameters model) {
            batchSize(model.batchSize);
            credentials(model.credentials);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final MSKAccessCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(MSKAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MSKAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        @Override
        public UpdatePipeSourceManagedStreamingKafkaParameters build() {
            return new UpdatePipeSourceManagedStreamingKafkaParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
