/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipeRequest extends PipesRequest implements
        ToCopyableBuilder<UpdatePipeRequest.Builder, UpdatePipeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePipeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePipeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(UpdatePipeRequest::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<UpdatePipeSourceParameters> SOURCE_PARAMETERS_FIELD = SdkField
            .<UpdatePipeSourceParameters> builder(MarshallingType.SDK_POJO).memberName("SourceParameters")
            .getter(getter(UpdatePipeRequest::sourceParameters)).setter(setter(Builder::sourceParameters))
            .constructor(UpdatePipeSourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameters").build()).build();

    private static final SdkField<String> ENRICHMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Enrichment").getter(getter(UpdatePipeRequest::enrichment)).setter(setter(Builder::enrichment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enrichment").build()).build();

    private static final SdkField<PipeEnrichmentParameters> ENRICHMENT_PARAMETERS_FIELD = SdkField
            .<PipeEnrichmentParameters> builder(MarshallingType.SDK_POJO).memberName("EnrichmentParameters")
            .getter(getter(UpdatePipeRequest::enrichmentParameters)).setter(setter(Builder::enrichmentParameters))
            .constructor(PipeEnrichmentParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrichmentParameters").build())
            .build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(UpdatePipeRequest::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<PipeTargetParameters> TARGET_PARAMETERS_FIELD = SdkField
            .<PipeTargetParameters> builder(MarshallingType.SDK_POJO).memberName("TargetParameters")
            .getter(getter(UpdatePipeRequest::targetParameters)).setter(setter(Builder::targetParameters))
            .constructor(PipeTargetParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameters").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdatePipeRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<PipeLogConfigurationParameters> LOG_CONFIGURATION_FIELD = SdkField
            .<PipeLogConfigurationParameters> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(UpdatePipeRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(PipeLogConfigurationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(UpdatePipeRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DESIRED_STATE_FIELD, SOURCE_PARAMETERS_FIELD, ENRICHMENT_FIELD, ENRICHMENT_PARAMETERS_FIELD, TARGET_FIELD,
            TARGET_PARAMETERS_FIELD, ROLE_ARN_FIELD, LOG_CONFIGURATION_FIELD, KMS_KEY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String desiredState;

    private final UpdatePipeSourceParameters sourceParameters;

    private final String enrichment;

    private final PipeEnrichmentParameters enrichmentParameters;

    private final String target;

    private final PipeTargetParameters targetParameters;

    private final String roleArn;

    private final PipeLogConfigurationParameters logConfiguration;

    private final String kmsKeyIdentifier;

    private UpdatePipeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.desiredState = builder.desiredState;
        this.sourceParameters = builder.sourceParameters;
        this.enrichment = builder.enrichment;
        this.enrichmentParameters = builder.enrichmentParameters;
        this.target = builder.target;
        this.targetParameters = builder.targetParameters;
        this.roleArn = builder.roleArn;
        this.logConfiguration = builder.logConfiguration;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    /**
     * <p>
     * The name of the pipe.
     * </p>
     * 
     * @return The name of the pipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the pipe.
     * </p>
     * 
     * @return A description of the pipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(desiredState);
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The parameters required to set up a source for your pipe.
     * </p>
     * 
     * @return The parameters required to set up a source for your pipe.
     */
    public final UpdatePipeSourceParameters sourceParameters() {
        return sourceParameters;
    }

    /**
     * <p>
     * The ARN of the enrichment resource.
     * </p>
     * 
     * @return The ARN of the enrichment resource.
     */
    public final String enrichment() {
        return enrichment;
    }

    /**
     * <p>
     * The parameters required to set up enrichment on your pipe.
     * </p>
     * 
     * @return The parameters required to set up enrichment on your pipe.
     */
    public final PipeEnrichmentParameters enrichmentParameters() {
        return enrichmentParameters;
    }

    /**
     * <p>
     * The ARN of the target resource.
     * </p>
     * 
     * @return The ARN of the target resource.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The parameters required to set up a target for your pipe.
     * </p>
     * <p>
     * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a>
     * in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The parameters required to set up a target for your pipe.</p>
     *         <p>
     *         For more information about pipe target parameters, including how to use dynamic path parameters, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
     *         parameters</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final PipeTargetParameters targetParameters() {
        return targetParameters;
    }

    /**
     * <p>
     * The ARN of the role that allows the pipe to send data to the target.
     * </p>
     * 
     * @return The ARN of the role that allows the pipe to send data to the target.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The logging configuration settings for the pipe.
     * </p>
     * 
     * @return The logging configuration settings for the pipe.
     */
    public final PipeLogConfigurationParameters logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed
     * key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key
     * alias ARN.
     * </p>
     * <p>
     * To update a pipe that is using the default Amazon Web Services owned key to use a customer managed key instead,
     * or update a pipe that is using a customer managed key to use a different customer managed key, specify a customer
     * managed key identifier.
     * </p>
     * <p>
     * To update a pipe that is using a customer managed key to use the default Amazon Web Services owned key, specify
     * an empty string.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html">Managing keys</a> in the <i>Key
     * Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
     *         managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
     *         alias, or key alias ARN.</p>
     *         <p>
     *         To update a pipe that is using the default Amazon Web Services owned key to use a customer managed key
     *         instead, or update a pipe that is using a customer managed key to use a different customer managed key,
     *         specify a customer managed key identifier.
     *         </p>
     *         <p>
     *         To update a pipe that is using a customer managed key to use the default Amazon Web Services owned key,
     *         specify an empty string.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html">Managing keys</a> in
     *         the <i>Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(enrichment());
        hashCode = 31 * hashCode + Objects.hashCode(enrichmentParameters());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameters());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeRequest)) {
            return false;
        }
        UpdatePipeRequest other = (UpdatePipeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(sourceParameters(), other.sourceParameters())
                && Objects.equals(enrichment(), other.enrichment())
                && Objects.equals(enrichmentParameters(), other.enrichmentParameters())
                && Objects.equals(target(), other.target()) && Objects.equals(targetParameters(), other.targetParameters())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipeRequest").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DesiredState", desiredStateAsString()).add("SourceParameters", sourceParameters())
                .add("Enrichment", enrichment()).add("EnrichmentParameters", enrichmentParameters()).add("Target", target())
                .add("TargetParameters", targetParameters()).add("RoleArn", roleArn())
                .add("LogConfiguration", logConfiguration()).add("KmsKeyIdentifier", kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "SourceParameters":
            return Optional.ofNullable(clazz.cast(sourceParameters()));
        case "Enrichment":
            return Optional.ofNullable(clazz.cast(enrichment()));
        case "EnrichmentParameters":
            return Optional.ofNullable(clazz.cast(enrichmentParameters()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "TargetParameters":
            return Optional.ofNullable(clazz.cast(targetParameters()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("SourceParameters", SOURCE_PARAMETERS_FIELD);
        map.put("Enrichment", ENRICHMENT_FIELD);
        map.put("EnrichmentParameters", ENRICHMENT_PARAMETERS_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("TargetParameters", TARGET_PARAMETERS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeRequest, T> g) {
        return obj -> g.apply((UpdatePipeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PipesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipeRequest> {
        /**
         * <p>
         * The name of the pipe.
         * </p>
         * 
         * @param name
         *        The name of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the pipe.
         * </p>
         * 
         * @param description
         *        A description of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(RequestedPipeState desiredState);

        /**
         * <p>
         * The parameters required to set up a source for your pipe.
         * </p>
         * 
         * @param sourceParameters
         *        The parameters required to set up a source for your pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameters(UpdatePipeSourceParameters sourceParameters);

        /**
         * <p>
         * The parameters required to set up a source for your pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdatePipeSourceParameters.Builder}
         * avoiding the need to create one manually via {@link UpdatePipeSourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePipeSourceParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceParameters(UpdatePipeSourceParameters)}.
         * 
         * @param sourceParameters
         *        a consumer that will call methods on {@link UpdatePipeSourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceParameters(UpdatePipeSourceParameters)
         */
        default Builder sourceParameters(Consumer<UpdatePipeSourceParameters.Builder> sourceParameters) {
            return sourceParameters(UpdatePipeSourceParameters.builder().applyMutation(sourceParameters).build());
        }

        /**
         * <p>
         * The ARN of the enrichment resource.
         * </p>
         * 
         * @param enrichment
         *        The ARN of the enrichment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichment(String enrichment);

        /**
         * <p>
         * The parameters required to set up enrichment on your pipe.
         * </p>
         * 
         * @param enrichmentParameters
         *        The parameters required to set up enrichment on your pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters);

        /**
         * <p>
         * The parameters required to set up enrichment on your pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeEnrichmentParameters.Builder}
         * avoiding the need to create one manually via {@link PipeEnrichmentParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeEnrichmentParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #enrichmentParameters(PipeEnrichmentParameters)}.
         * 
         * @param enrichmentParameters
         *        a consumer that will call methods on {@link PipeEnrichmentParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrichmentParameters(PipeEnrichmentParameters)
         */
        default Builder enrichmentParameters(Consumer<PipeEnrichmentParameters.Builder> enrichmentParameters) {
            return enrichmentParameters(PipeEnrichmentParameters.builder().applyMutation(enrichmentParameters).build());
        }

        /**
         * <p>
         * The ARN of the target resource.
         * </p>
         * 
         * @param target
         *        The ARN of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The parameters required to set up a target for your pipe.
         * </p>
         * <p>
         * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         * parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param targetParameters
         *        The parameters required to set up a target for your pipe.</p>
         *        <p>
         *        For more information about pipe target parameters, including how to use dynamic path parameters, see
         *        <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         *        parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameters(PipeTargetParameters targetParameters);

        /**
         * <p>
         * The parameters required to set up a target for your pipe.
         * </p>
         * <p>
         * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target
         * parameters</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetParameters.Builder} avoiding
         * the need to create one manually via {@link PipeTargetParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #targetParameters(PipeTargetParameters)}.
         * 
         * @param targetParameters
         *        a consumer that will call methods on {@link PipeTargetParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetParameters(PipeTargetParameters)
         */
        default Builder targetParameters(Consumer<PipeTargetParameters.Builder> targetParameters) {
            return targetParameters(PipeTargetParameters.builder().applyMutation(targetParameters).build());
        }

        /**
         * <p>
         * The ARN of the role that allows the pipe to send data to the target.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that allows the pipe to send data to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The logging configuration settings for the pipe.
         * </p>
         * 
         * @param logConfiguration
         *        The logging configuration settings for the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(PipeLogConfigurationParameters logConfiguration);

        /**
         * <p>
         * The logging configuration settings for the pipe.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeLogConfigurationParameters.Builder}
         * avoiding the need to create one manually via {@link PipeLogConfigurationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeLogConfigurationParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #logConfiguration(PipeLogConfigurationParameters)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link PipeLogConfigurationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(PipeLogConfigurationParameters)
         */
        default Builder logConfiguration(Consumer<PipeLogConfigurationParameters.Builder> logConfiguration) {
            return logConfiguration(PipeLogConfigurationParameters.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         * managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias,
         * or key alias ARN.
         * </p>
         * <p>
         * To update a pipe that is using the default Amazon Web Services owned key to use a customer managed key
         * instead, or update a pipe that is using a customer managed key to use a different customer managed key,
         * specify a customer managed key identifier.
         * </p>
         * <p>
         * To update a pipe that is using a customer managed key to use the default Amazon Web Services owned key,
         * specify an empty string.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html">Managing keys</a> in the
         * <i>Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         *        managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
         *        alias, or key alias ARN.</p>
         *        <p>
         *        To update a pipe that is using the default Amazon Web Services owned key to use a customer managed key
         *        instead, or update a pipe that is using a customer managed key to use a different customer managed
         *        key, specify a customer managed key identifier.
         *        </p>
         *        <p>
         *        To update a pipe that is using a customer managed key to use the default Amazon Web Services owned
         *        key, specify an empty string.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html">Managing keys</a> in
         *        the <i>Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PipesRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String desiredState;

        private UpdatePipeSourceParameters sourceParameters;

        private String enrichment;

        private PipeEnrichmentParameters enrichmentParameters;

        private String target;

        private PipeTargetParameters targetParameters;

        private String roleArn;

        private PipeLogConfigurationParameters logConfiguration;

        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            desiredState(model.desiredState);
            sourceParameters(model.sourceParameters);
            enrichment(model.enrichment);
            enrichmentParameters(model.enrichmentParameters);
            target(model.target);
            targetParameters(model.targetParameters);
            roleArn(model.roleArn);
            logConfiguration(model.logConfiguration);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final UpdatePipeSourceParameters.Builder getSourceParameters() {
            return sourceParameters != null ? sourceParameters.toBuilder() : null;
        }

        public final void setSourceParameters(UpdatePipeSourceParameters.BuilderImpl sourceParameters) {
            this.sourceParameters = sourceParameters != null ? sourceParameters.build() : null;
        }

        @Override
        public final Builder sourceParameters(UpdatePipeSourceParameters sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        public final String getEnrichment() {
            return enrichment;
        }

        public final void setEnrichment(String enrichment) {
            this.enrichment = enrichment;
        }

        @Override
        public final Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public final PipeEnrichmentParameters.Builder getEnrichmentParameters() {
            return enrichmentParameters != null ? enrichmentParameters.toBuilder() : null;
        }

        public final void setEnrichmentParameters(PipeEnrichmentParameters.BuilderImpl enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters != null ? enrichmentParameters.build() : null;
        }

        @Override
        public final Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final PipeTargetParameters.Builder getTargetParameters() {
            return targetParameters != null ? targetParameters.toBuilder() : null;
        }

        public final void setTargetParameters(PipeTargetParameters.BuilderImpl targetParameters) {
            this.targetParameters = targetParameters != null ? targetParameters.build() : null;
        }

        @Override
        public final Builder targetParameters(PipeTargetParameters targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final PipeLogConfigurationParameters.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(PipeLogConfigurationParameters.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(PipeLogConfigurationParameters logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipeRequest build() {
            return new UpdatePipeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
