/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.EcsContainerOverride;
import software.amazon.awssdk.services.pipes.model.EcsContainerOverrideListCopier;
import software.amazon.awssdk.services.pipes.model.EcsEphemeralStorage;
import software.amazon.awssdk.services.pipes.model.EcsInferenceAcceleratorOverride;
import software.amazon.awssdk.services.pipes.model.EcsInferenceAcceleratorOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsTaskOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsTaskOverride> {
    private static final SdkField<List<EcsContainerOverride>> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerOverrides").getter(EcsTaskOverride.getter(EcsTaskOverride::containerOverrides)).setter(EcsTaskOverride.setter(Builder::containerOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsContainerOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cpu").getter(EcsTaskOverride.getter(EcsTaskOverride::cpu)).setter(EcsTaskOverride.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()}).build();
    private static final SdkField<EcsEphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EphemeralStorage").getter(EcsTaskOverride.getter(EcsTaskOverride::ephemeralStorage)).setter(EcsTaskOverride.setter(Builder::ephemeralStorage)).constructor(EcsEphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(EcsTaskOverride.getter(EcsTaskOverride::executionRoleArn)).setter(EcsTaskOverride.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<List<EcsInferenceAcceleratorOverride>> INFERENCE_ACCELERATOR_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceAcceleratorOverrides").getter(EcsTaskOverride.getter(EcsTaskOverride::inferenceAcceleratorOverrides)).setter(EcsTaskOverride.setter(Builder::inferenceAcceleratorOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAcceleratorOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsInferenceAcceleratorOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Memory").getter(EcsTaskOverride.getter(EcsTaskOverride::memory)).setter(EcsTaskOverride.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskRoleArn").getter(EcsTaskOverride.getter(EcsTaskOverride::taskRoleArn)).setter(EcsTaskOverride.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_OVERRIDES_FIELD, CPU_FIELD, EPHEMERAL_STORAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, INFERENCE_ACCELERATOR_OVERRIDES_FIELD, MEMORY_FIELD, TASK_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsTaskOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EcsContainerOverride> containerOverrides;
    private final String cpu;
    private final EcsEphemeralStorage ephemeralStorage;
    private final String executionRoleArn;
    private final List<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides;
    private final String memory;
    private final String taskRoleArn;

    private EcsTaskOverride(BuilderImpl builder) {
        this.containerOverrides = builder.containerOverrides;
        this.cpu = builder.cpu;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.executionRoleArn = builder.executionRoleArn;
        this.inferenceAcceleratorOverrides = builder.inferenceAcceleratorOverrides;
        this.memory = builder.memory;
        this.taskRoleArn = builder.taskRoleArn;
    }

    public final boolean hasContainerOverrides() {
        return this.containerOverrides != null && !(this.containerOverrides instanceof SdkAutoConstructList);
    }

    public final List<EcsContainerOverride> containerOverrides() {
        return this.containerOverrides;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final EcsEphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final boolean hasInferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides != null && !(this.inferenceAcceleratorOverrides instanceof SdkAutoConstructList);
    }

    public final List<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides;
    }

    public final String memory() {
        return this.memory;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerOverrides() ? this.containerOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceAcceleratorOverrides() ? this.inferenceAcceleratorOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskOverride)) {
            return false;
        }
        EcsTaskOverride other = (EcsTaskOverride)obj;
        return this.hasContainerOverrides() == other.hasContainerOverrides() && Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && this.hasInferenceAcceleratorOverrides() == other.hasInferenceAcceleratorOverrides() && Objects.equals(this.inferenceAcceleratorOverrides(), other.inferenceAcceleratorOverrides()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"EcsTaskOverride").add("ContainerOverrides", this.hasContainerOverrides() ? this.containerOverrides() : null).add("Cpu", (Object)this.cpu()).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("InferenceAcceleratorOverrides", this.hasInferenceAcceleratorOverrides() ? this.inferenceAcceleratorOverrides() : null).add("Memory", (Object)this.memory()).add("TaskRoleArn", (Object)this.taskRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "Cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "EphemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "InferenceAcceleratorOverrides": {
                return Optional.ofNullable(clazz.cast(this.inferenceAcceleratorOverrides()));
            }
            case "Memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "TaskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerOverrides", CONTAINER_OVERRIDES_FIELD);
        map.put("Cpu", CPU_FIELD);
        map.put("EphemeralStorage", EPHEMERAL_STORAGE_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("InferenceAcceleratorOverrides", INFERENCE_ACCELERATOR_OVERRIDES_FIELD);
        map.put("Memory", MEMORY_FIELD);
        map.put("TaskRoleArn", TASK_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsTaskOverride, T> g) {
        return obj -> g.apply((EcsTaskOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EcsContainerOverride> containerOverrides = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private EcsEphemeralStorage ephemeralStorage;
        private String executionRoleArn;
        private List<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides = DefaultSdkAutoConstructList.getInstance();
        private String memory;
        private String taskRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTaskOverride model) {
            this.containerOverrides(model.containerOverrides);
            this.cpu(model.cpu);
            this.ephemeralStorage(model.ephemeralStorage);
            this.executionRoleArn(model.executionRoleArn);
            this.inferenceAcceleratorOverrides(model.inferenceAcceleratorOverrides);
            this.memory(model.memory);
            this.taskRoleArn(model.taskRoleArn);
        }

        public final List<EcsContainerOverride.Builder> getContainerOverrides() {
            List<EcsContainerOverride.Builder> result = EcsContainerOverrideListCopier.copyToBuilder(this.containerOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerOverrides(Collection<EcsContainerOverride.BuilderImpl> containerOverrides) {
            this.containerOverrides = EcsContainerOverrideListCopier.copyFromBuilder(containerOverrides);
        }

        @Override
        public final Builder containerOverrides(Collection<EcsContainerOverride> containerOverrides) {
            this.containerOverrides = EcsContainerOverrideListCopier.copy(containerOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(EcsContainerOverride ... containerOverrides) {
            this.containerOverrides(Arrays.asList(containerOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(Consumer<EcsContainerOverride.Builder> ... containerOverrides) {
            this.containerOverrides(Stream.of(containerOverrides).map(c -> (EcsContainerOverride)((EcsContainerOverride.Builder)EcsContainerOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final EcsEphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EcsEphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EcsEphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final List<EcsInferenceAcceleratorOverride.Builder> getInferenceAcceleratorOverrides() {
            List<EcsInferenceAcceleratorOverride.Builder> result = EcsInferenceAcceleratorOverrideListCopier.copyToBuilder(this.inferenceAcceleratorOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAcceleratorOverrides(Collection<EcsInferenceAcceleratorOverride.BuilderImpl> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = EcsInferenceAcceleratorOverrideListCopier.copyFromBuilder(inferenceAcceleratorOverrides);
        }

        @Override
        public final Builder inferenceAcceleratorOverrides(Collection<EcsInferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = EcsInferenceAcceleratorOverrideListCopier.copy(inferenceAcceleratorOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(EcsInferenceAcceleratorOverride ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Arrays.asList(inferenceAcceleratorOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(Consumer<EcsInferenceAcceleratorOverride.Builder> ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Stream.of(inferenceAcceleratorOverrides).map(c -> (EcsInferenceAcceleratorOverride)((EcsInferenceAcceleratorOverride.Builder)EcsInferenceAcceleratorOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public EcsTaskOverride build() {
            return new EcsTaskOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsTaskOverride> {
        public Builder containerOverrides(Collection<EcsContainerOverride> var1);

        public Builder containerOverrides(EcsContainerOverride ... var1);

        public Builder containerOverrides(Consumer<EcsContainerOverride.Builder> ... var1);

        public Builder cpu(String var1);

        public Builder ephemeralStorage(EcsEphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EcsEphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EcsEphemeralStorage)((EcsEphemeralStorage.Builder)EcsEphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder inferenceAcceleratorOverrides(Collection<EcsInferenceAcceleratorOverride> var1);

        public Builder inferenceAcceleratorOverrides(EcsInferenceAcceleratorOverride ... var1);

        public Builder inferenceAcceleratorOverrides(Consumer<EcsInferenceAcceleratorOverride.Builder> ... var1);

        public Builder memory(String var1);

        public Builder taskRoleArn(String var1);
    }
}

