/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.EcsEnvironmentFile;
import software.amazon.awssdk.services.pipes.model.EcsEnvironmentFileListCopier;
import software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariable;
import software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariableListCopier;
import software.amazon.awssdk.services.pipes.model.EcsResourceRequirement;
import software.amazon.awssdk.services.pipes.model.EcsResourceRequirementsListCopier;
import software.amazon.awssdk.services.pipes.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsContainerOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsContainerOverride> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Command").getter(EcsContainerOverride.getter(EcsContainerOverride::command)).setter(EcsContainerOverride.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cpu").getter(EcsContainerOverride.getter(EcsContainerOverride::cpu)).setter(EcsContainerOverride.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()}).build();
    private static final SdkField<List<EcsEnvironmentVariable>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Environment").getter(EcsContainerOverride.getter(EcsContainerOverride::environment)).setter(EcsContainerOverride.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsEnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EcsEnvironmentFile>> ENVIRONMENT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentFiles").getter(EcsContainerOverride.getter(EcsContainerOverride::environmentFiles)).setter(EcsContainerOverride.setter(Builder::environmentFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsEnvironmentFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Memory").getter(EcsContainerOverride.getter(EcsContainerOverride::memory)).setter(EcsContainerOverride.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()}).build();
    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemoryReservation").getter(EcsContainerOverride.getter(EcsContainerOverride::memoryReservation)).setter(EcsContainerOverride.setter(Builder::memoryReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryReservation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EcsContainerOverride.getter(EcsContainerOverride::name)).setter(EcsContainerOverride.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<EcsResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceRequirements").getter(EcsContainerOverride.getter(EcsContainerOverride::resourceRequirements)).setter(EcsContainerOverride.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EcsResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, CPU_FIELD, ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, NAME_FIELD, RESOURCE_REQUIREMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsContainerOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> command;
    private final Integer cpu;
    private final List<EcsEnvironmentVariable> environment;
    private final List<EcsEnvironmentFile> environmentFiles;
    private final Integer memory;
    private final Integer memoryReservation;
    private final String name;
    private final List<EcsResourceRequirement> resourceRequirements;

    private EcsContainerOverride(BuilderImpl builder) {
        this.command = builder.command;
        this.cpu = builder.cpu;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.name = builder.name;
        this.resourceRequirements = builder.resourceRequirements;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<EcsEnvironmentVariable> environment() {
        return this.environment;
    }

    public final boolean hasEnvironmentFiles() {
        return this.environmentFiles != null && !(this.environmentFiles instanceof SdkAutoConstructList);
    }

    public final List<EcsEnvironmentFile> environmentFiles() {
        return this.environmentFiles;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer memoryReservation() {
        return this.memoryReservation;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<EcsResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentFiles() ? this.environmentFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsContainerOverride)) {
            return false;
        }
        EcsContainerOverride other = (EcsContainerOverride)obj;
        return this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && Objects.equals(this.cpu(), other.cpu()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasEnvironmentFiles() == other.hasEnvironmentFiles() && Objects.equals(this.environmentFiles(), other.environmentFiles()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.memoryReservation(), other.memoryReservation()) && Objects.equals(this.name(), other.name()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"EcsContainerOverride").add("Command", this.hasCommand() ? this.command() : null).add("Cpu", (Object)this.cpu()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("EnvironmentFiles", this.hasEnvironmentFiles() ? this.environmentFiles() : null).add("Memory", (Object)this.memory()).add("MemoryReservation", (Object)this.memoryReservation()).add("Name", (Object)this.name()).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "EnvironmentFiles": {
                return Optional.ofNullable(clazz.cast(this.environmentFiles()));
            }
            case "Memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "MemoryReservation": {
                return Optional.ofNullable(clazz.cast(this.memoryReservation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Command", COMMAND_FIELD);
        map.put("Cpu", CPU_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("EnvironmentFiles", ENVIRONMENT_FILES_FIELD);
        map.put("Memory", MEMORY_FIELD);
        map.put("MemoryReservation", MEMORY_RESERVATION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResourceRequirements", RESOURCE_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsContainerOverride, T> g) {
        return obj -> g.apply((EcsContainerOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private Integer cpu;
        private List<EcsEnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();
        private List<EcsEnvironmentFile> environmentFiles = DefaultSdkAutoConstructList.getInstance();
        private Integer memory;
        private Integer memoryReservation;
        private String name;
        private List<EcsResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsContainerOverride model) {
            this.command(model.command);
            this.cpu(model.cpu);
            this.environment(model.environment);
            this.environmentFiles(model.environmentFiles);
            this.memory(model.memory);
            this.memoryReservation(model.memoryReservation);
            this.name(model.name);
            this.resourceRequirements(model.resourceRequirements);
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<EcsEnvironmentVariable.Builder> getEnvironment() {
            List<EcsEnvironmentVariable.Builder> result = EcsEnvironmentVariableListCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<EcsEnvironmentVariable.BuilderImpl> environment) {
            this.environment = EcsEnvironmentVariableListCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<EcsEnvironmentVariable> environment) {
            this.environment = EcsEnvironmentVariableListCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EcsEnvironmentVariable ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<EcsEnvironmentVariable.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (EcsEnvironmentVariable)((EcsEnvironmentVariable.Builder)EcsEnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EcsEnvironmentFile.Builder> getEnvironmentFiles() {
            List<EcsEnvironmentFile.Builder> result = EcsEnvironmentFileListCopier.copyToBuilder(this.environmentFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFiles(Collection<EcsEnvironmentFile.BuilderImpl> environmentFiles) {
            this.environmentFiles = EcsEnvironmentFileListCopier.copyFromBuilder(environmentFiles);
        }

        @Override
        public final Builder environmentFiles(Collection<EcsEnvironmentFile> environmentFiles) {
            this.environmentFiles = EcsEnvironmentFileListCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(EcsEnvironmentFile ... environmentFiles) {
            this.environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(Consumer<EcsEnvironmentFile.Builder> ... environmentFiles) {
            this.environmentFiles(Stream.of(environmentFiles).map(c -> (EcsEnvironmentFile)((EcsEnvironmentFile.Builder)EcsEnvironmentFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return this.memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<EcsResourceRequirement.Builder> getResourceRequirements() {
            List<EcsResourceRequirement.Builder> result = EcsResourceRequirementsListCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<EcsResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = EcsResourceRequirementsListCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<EcsResourceRequirement> resourceRequirements) {
            this.resourceRequirements = EcsResourceRequirementsListCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(EcsResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<EcsResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (EcsResourceRequirement)((EcsResourceRequirement.Builder)EcsResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EcsContainerOverride build() {
            return new EcsContainerOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsContainerOverride> {
        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder cpu(Integer var1);

        public Builder environment(Collection<EcsEnvironmentVariable> var1);

        public Builder environment(EcsEnvironmentVariable ... var1);

        public Builder environment(Consumer<EcsEnvironmentVariable.Builder> ... var1);

        public Builder environmentFiles(Collection<EcsEnvironmentFile> var1);

        public Builder environmentFiles(EcsEnvironmentFile ... var1);

        public Builder environmentFiles(Consumer<EcsEnvironmentFile.Builder> ... var1);

        public Builder memory(Integer var1);

        public Builder memoryReservation(Integer var1);

        public Builder name(String var1);

        public Builder resourceRequirements(Collection<EcsResourceRequirement> var1);

        public Builder resourceRequirements(EcsResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<EcsResourceRequirement.Builder> ... var1);
    }
}

