/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PipeTargetInvocationType {
    REQUEST_RESPONSE("REQUEST_RESPONSE"),
    FIRE_AND_FORGET("FIRE_AND_FORGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PipeTargetInvocationType> VALUE_MAP;
    private final String value;

    private PipeTargetInvocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PipeTargetInvocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PipeTargetInvocationType> knownValues() {
        EnumSet<PipeTargetInvocationType> knownValues = EnumSet.allOf(PipeTargetInvocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PipeTargetInvocationType.class, PipeTargetInvocationType::toString);
    }
}

