/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.FilterCriteria;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceActiveMQBrokerParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceDynamoDBStreamParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceKinesisStreamParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceManagedStreamingKafkaParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceRabbitMQBrokerParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceSelfManagedKafkaParameters;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceSqsQueueParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeSourceParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatePipeSourceParameters> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::filterCriteria)).setter(UpdatePipeSourceParameters.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<UpdatePipeSourceKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::kinesisStreamParameters)).setter(UpdatePipeSourceParameters.setter(Builder::kinesisStreamParameters)).constructor(UpdatePipeSourceKinesisStreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceDynamoDBStreamParameters> DYNAMO_DB_STREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamoDBStreamParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::dynamoDBStreamParameters)).setter(UpdatePipeSourceParameters.setter(Builder::dynamoDBStreamParameters)).constructor(UpdatePipeSourceDynamoDBStreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBStreamParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqsQueueParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::sqsQueueParameters)).setter(UpdatePipeSourceParameters.setter(Builder::sqsQueueParameters)).constructor(UpdatePipeSourceSqsQueueParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceActiveMQBrokerParameters> ACTIVE_MQ_BROKER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveMQBrokerParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::activeMQBrokerParameters)).setter(UpdatePipeSourceParameters.setter(Builder::activeMQBrokerParameters)).constructor(UpdatePipeSourceActiveMQBrokerParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveMQBrokerParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceRabbitMQBrokerParameters> RABBIT_MQ_BROKER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RabbitMQBrokerParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::rabbitMQBrokerParameters)).setter(UpdatePipeSourceParameters.setter(Builder::rabbitMQBrokerParameters)).constructor(UpdatePipeSourceRabbitMQBrokerParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RabbitMQBrokerParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceManagedStreamingKafkaParameters> MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedStreamingKafkaParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::managedStreamingKafkaParameters)).setter(UpdatePipeSourceParameters.setter(Builder::managedStreamingKafkaParameters)).constructor(UpdatePipeSourceManagedStreamingKafkaParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStreamingKafkaParameters").build()}).build();
    private static final SdkField<UpdatePipeSourceSelfManagedKafkaParameters> SELF_MANAGED_KAFKA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedKafkaParameters").getter(UpdatePipeSourceParameters.getter(UpdatePipeSourceParameters::selfManagedKafkaParameters)).setter(UpdatePipeSourceParameters.setter(Builder::selfManagedKafkaParameters)).constructor(UpdatePipeSourceSelfManagedKafkaParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, KINESIS_STREAM_PARAMETERS_FIELD, DYNAMO_DB_STREAM_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD, ACTIVE_MQ_BROKER_PARAMETERS_FIELD, RABBIT_MQ_BROKER_PARAMETERS_FIELD, MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD, SELF_MANAGED_KAFKA_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FilterCriteria filterCriteria;
    private final UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters;
    private final UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;
    private final UpdatePipeSourceSqsQueueParameters sqsQueueParameters;
    private final UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters;
    private final UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;
    private final UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;
    private final UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

    private UpdatePipeSourceParameters(BuilderImpl builder) {
        this.filterCriteria = builder.filterCriteria;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.dynamoDBStreamParameters = builder.dynamoDBStreamParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.activeMQBrokerParameters = builder.activeMQBrokerParameters;
        this.rabbitMQBrokerParameters = builder.rabbitMQBrokerParameters;
        this.managedStreamingKafkaParameters = builder.managedStreamingKafkaParameters;
        this.selfManagedKafkaParameters = builder.selfManagedKafkaParameters;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters() {
        return this.kinesisStreamParameters;
    }

    public final UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters() {
        return this.dynamoDBStreamParameters;
    }

    public final UpdatePipeSourceSqsQueueParameters sqsQueueParameters() {
        return this.sqsQueueParameters;
    }

    public final UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters() {
        return this.activeMQBrokerParameters;
    }

    public final UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters() {
        return this.rabbitMQBrokerParameters;
    }

    public final UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters() {
        return this.managedStreamingKafkaParameters;
    }

    public final UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters() {
        return this.selfManagedKafkaParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.rabbitMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedStreamingKafkaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedKafkaParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceParameters)) {
            return false;
        }
        UpdatePipeSourceParameters other = (UpdatePipeSourceParameters)obj;
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.kinesisStreamParameters(), other.kinesisStreamParameters()) && Objects.equals(this.dynamoDBStreamParameters(), other.dynamoDBStreamParameters()) && Objects.equals(this.sqsQueueParameters(), other.sqsQueueParameters()) && Objects.equals(this.activeMQBrokerParameters(), other.activeMQBrokerParameters()) && Objects.equals(this.rabbitMQBrokerParameters(), other.rabbitMQBrokerParameters()) && Objects.equals(this.managedStreamingKafkaParameters(), other.managedStreamingKafkaParameters()) && Objects.equals(this.selfManagedKafkaParameters(), other.selfManagedKafkaParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeSourceParameters").add("FilterCriteria", (Object)this.filterCriteria()).add("KinesisStreamParameters", (Object)this.kinesisStreamParameters()).add("DynamoDBStreamParameters", (Object)this.dynamoDBStreamParameters()).add("SqsQueueParameters", (Object)this.sqsQueueParameters()).add("ActiveMQBrokerParameters", (Object)this.activeMQBrokerParameters()).add("RabbitMQBrokerParameters", (Object)this.rabbitMQBrokerParameters()).add("ManagedStreamingKafkaParameters", (Object)this.managedStreamingKafkaParameters()).add("SelfManagedKafkaParameters", (Object)this.selfManagedKafkaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "KinesisStreamParameters": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamParameters()));
            }
            case "DynamoDBStreamParameters": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBStreamParameters()));
            }
            case "SqsQueueParameters": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueParameters()));
            }
            case "ActiveMQBrokerParameters": {
                return Optional.ofNullable(clazz.cast(this.activeMQBrokerParameters()));
            }
            case "RabbitMQBrokerParameters": {
                return Optional.ofNullable(clazz.cast(this.rabbitMQBrokerParameters()));
            }
            case "ManagedStreamingKafkaParameters": {
                return Optional.ofNullable(clazz.cast(this.managedStreamingKafkaParameters()));
            }
            case "SelfManagedKafkaParameters": {
                return Optional.ofNullable(clazz.cast(this.selfManagedKafkaParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FilterCriteria filterCriteria;
        private UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters;
        private UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;
        private UpdatePipeSourceSqsQueueParameters sqsQueueParameters;
        private UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters;
        private UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;
        private UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;
        private UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceParameters model) {
            this.filterCriteria(model.filterCriteria);
            this.kinesisStreamParameters(model.kinesisStreamParameters);
            this.dynamoDBStreamParameters(model.dynamoDBStreamParameters);
            this.sqsQueueParameters(model.sqsQueueParameters);
            this.activeMQBrokerParameters(model.activeMQBrokerParameters);
            this.rabbitMQBrokerParameters(model.rabbitMQBrokerParameters);
            this.managedStreamingKafkaParameters(model.managedStreamingKafkaParameters);
            this.selfManagedKafkaParameters(model.selfManagedKafkaParameters);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final UpdatePipeSourceKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return this.kinesisStreamParameters != null ? this.kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final UpdatePipeSourceDynamoDBStreamParameters.Builder getDynamoDBStreamParameters() {
            return this.dynamoDBStreamParameters != null ? this.dynamoDBStreamParameters.toBuilder() : null;
        }

        public final void setDynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters.BuilderImpl dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters != null ? dynamoDBStreamParameters.build() : null;
        }

        @Override
        public final Builder dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters;
            return this;
        }

        public final UpdatePipeSourceSqsQueueParameters.Builder getSqsQueueParameters() {
            return this.sqsQueueParameters != null ? this.sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(UpdatePipeSourceSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(UpdatePipeSourceSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final UpdatePipeSourceActiveMQBrokerParameters.Builder getActiveMQBrokerParameters() {
            return this.activeMQBrokerParameters != null ? this.activeMQBrokerParameters.toBuilder() : null;
        }

        public final void setActiveMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters.BuilderImpl activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters != null ? activeMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters;
            return this;
        }

        public final UpdatePipeSourceRabbitMQBrokerParameters.Builder getRabbitMQBrokerParameters() {
            return this.rabbitMQBrokerParameters != null ? this.rabbitMQBrokerParameters.toBuilder() : null;
        }

        public final void setRabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters.BuilderImpl rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters;
            return this;
        }

        public final UpdatePipeSourceManagedStreamingKafkaParameters.Builder getManagedStreamingKafkaParameters() {
            return this.managedStreamingKafkaParameters != null ? this.managedStreamingKafkaParameters.toBuilder() : null;
        }

        public final void setManagedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters.BuilderImpl managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters.build() : null;
        }

        @Override
        public final Builder managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
            return this;
        }

        public final UpdatePipeSourceSelfManagedKafkaParameters.Builder getSelfManagedKafkaParameters() {
            return this.selfManagedKafkaParameters != null ? this.selfManagedKafkaParameters.toBuilder() : null;
        }

        public final void setSelfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters.BuilderImpl selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters != null ? selfManagedKafkaParameters.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters;
            return this;
        }

        public UpdatePipeSourceParameters build() {
            return new UpdatePipeSourceParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatePipeSourceParameters> {
        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder kinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters var1);

        default public Builder kinesisStreamParameters(Consumer<UpdatePipeSourceKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return this.kinesisStreamParameters((UpdatePipeSourceKinesisStreamParameters)((UpdatePipeSourceKinesisStreamParameters.Builder)UpdatePipeSourceKinesisStreamParameters.builder().applyMutation(kinesisStreamParameters)).build());
        }

        public Builder dynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters var1);

        default public Builder dynamoDBStreamParameters(Consumer<UpdatePipeSourceDynamoDBStreamParameters.Builder> dynamoDBStreamParameters) {
            return this.dynamoDBStreamParameters((UpdatePipeSourceDynamoDBStreamParameters)((UpdatePipeSourceDynamoDBStreamParameters.Builder)UpdatePipeSourceDynamoDBStreamParameters.builder().applyMutation(dynamoDBStreamParameters)).build());
        }

        public Builder sqsQueueParameters(UpdatePipeSourceSqsQueueParameters var1);

        default public Builder sqsQueueParameters(Consumer<UpdatePipeSourceSqsQueueParameters.Builder> sqsQueueParameters) {
            return this.sqsQueueParameters((UpdatePipeSourceSqsQueueParameters)((UpdatePipeSourceSqsQueueParameters.Builder)UpdatePipeSourceSqsQueueParameters.builder().applyMutation(sqsQueueParameters)).build());
        }

        public Builder activeMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters var1);

        default public Builder activeMQBrokerParameters(Consumer<UpdatePipeSourceActiveMQBrokerParameters.Builder> activeMQBrokerParameters) {
            return this.activeMQBrokerParameters((UpdatePipeSourceActiveMQBrokerParameters)((UpdatePipeSourceActiveMQBrokerParameters.Builder)UpdatePipeSourceActiveMQBrokerParameters.builder().applyMutation(activeMQBrokerParameters)).build());
        }

        public Builder rabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters var1);

        default public Builder rabbitMQBrokerParameters(Consumer<UpdatePipeSourceRabbitMQBrokerParameters.Builder> rabbitMQBrokerParameters) {
            return this.rabbitMQBrokerParameters((UpdatePipeSourceRabbitMQBrokerParameters)((UpdatePipeSourceRabbitMQBrokerParameters.Builder)UpdatePipeSourceRabbitMQBrokerParameters.builder().applyMutation(rabbitMQBrokerParameters)).build());
        }

        public Builder managedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters var1);

        default public Builder managedStreamingKafkaParameters(Consumer<UpdatePipeSourceManagedStreamingKafkaParameters.Builder> managedStreamingKafkaParameters) {
            return this.managedStreamingKafkaParameters((UpdatePipeSourceManagedStreamingKafkaParameters)((UpdatePipeSourceManagedStreamingKafkaParameters.Builder)UpdatePipeSourceManagedStreamingKafkaParameters.builder().applyMutation(managedStreamingKafkaParameters)).build());
        }

        public Builder selfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters var1);

        default public Builder selfManagedKafkaParameters(Consumer<UpdatePipeSourceSelfManagedKafkaParameters.Builder> selfManagedKafkaParameters) {
            return this.selfManagedKafkaParameters((UpdatePipeSourceSelfManagedKafkaParameters)((UpdatePipeSourceSelfManagedKafkaParameters.Builder)UpdatePipeSourceSelfManagedKafkaParameters.builder().applyMutation(selfManagedKafkaParameters)).build());
        }
    }
}

