/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pipes.DefaultPipesAsyncClient;
import software.amazon.awssdk.services.pipes.DefaultPipesBaseClientBuilder;
import software.amazon.awssdk.services.pipes.PipesAsyncClient;
import software.amazon.awssdk.services.pipes.PipesAsyncClientBuilder;
import software.amazon.awssdk.services.pipes.PipesServiceClientConfiguration;
import software.amazon.awssdk.services.pipes.endpoints.PipesEndpointProvider;

@SdkInternalApi
final class DefaultPipesAsyncClientBuilder
extends DefaultPipesBaseClientBuilder<PipesAsyncClientBuilder, PipesAsyncClient>
implements PipesAsyncClientBuilder {
    DefaultPipesAsyncClientBuilder() {
    }

    @Override
    public DefaultPipesAsyncClientBuilder endpointProvider(PipesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PipesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPipesAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PipesServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPipesAsyncClient client = new DefaultPipesAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PipesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PipesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

