/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pipes.PipesClient;
import software.amazon.awssdk.services.pipes.model.ListPipesRequest;
import software.amazon.awssdk.services.pipes.model.ListPipesResponse;
import software.amazon.awssdk.services.pipes.model.Pipe;

public class ListPipesIterable
implements SdkIterable<ListPipesResponse> {
    private final PipesClient client;
    private final ListPipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipesIterable(PipesClient client, ListPipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipesResponseFetcher();
    }

    public Iterator<ListPipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Pipe> pipes() {
        Function<ListPipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipes() != null) {
                return response.pipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipesResponseFetcher
    implements SyncPageFetcher<ListPipesResponse> {
        private ListPipesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipesResponse nextPage(ListPipesResponse previousPage) {
            if (previousPage == null) {
                return ListPipesIterable.this.client.listPipes(ListPipesIterable.this.firstRequest);
            }
            return ListPipesIterable.this.client.listPipes((ListPipesRequest)((Object)ListPipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

