/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProtectConfigurationsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeProtectConfigurationsResponse> {
    private static final SdkField<List<ProtectConfigurationInformation>> PROTECT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectConfigurations").getter(DescribeProtectConfigurationsResponse.getter(DescribeProtectConfigurationsResponse::protectConfigurations)).setter(DescribeProtectConfigurationsResponse.setter(Builder::protectConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectConfigurationInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProtectConfigurationsResponse.getter(DescribeProtectConfigurationsResponse::nextToken)).setter(DescribeProtectConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeProtectConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ProtectConfigurationInformation> protectConfigurations;
    private final String nextToken;

    private DescribeProtectConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurations = builder.protectConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProtectConfigurations() {
        return this.protectConfigurations != null && !(this.protectConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProtectConfigurationInformation> protectConfigurations() {
        return this.protectConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectConfigurations() ? this.protectConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectConfigurationsResponse)) {
            return false;
        }
        DescribeProtectConfigurationsResponse other = (DescribeProtectConfigurationsResponse)((Object)obj);
        return this.hasProtectConfigurations() == other.hasProtectConfigurations() && Objects.equals(this.protectConfigurations(), other.protectConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProtectConfigurationsResponse").add("ProtectConfigurations", this.hasProtectConfigurations() ? this.protectConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurations": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectConfigurations", PROTECT_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeProtectConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<ProtectConfigurationInformation> protectConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectConfigurationsResponse model) {
            super(model);
            this.protectConfigurations(model.protectConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<ProtectConfigurationInformation.Builder> getProtectConfigurations() {
            List<ProtectConfigurationInformation.Builder> result = ProtectConfigurationInformationListCopier.copyToBuilder(this.protectConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectConfigurations(Collection<ProtectConfigurationInformation.BuilderImpl> protectConfigurations) {
            this.protectConfigurations = ProtectConfigurationInformationListCopier.copyFromBuilder(protectConfigurations);
        }

        @Override
        public final Builder protectConfigurations(Collection<ProtectConfigurationInformation> protectConfigurations) {
            this.protectConfigurations = ProtectConfigurationInformationListCopier.copy(protectConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectConfigurations(ProtectConfigurationInformation ... protectConfigurations) {
            this.protectConfigurations(Arrays.asList(protectConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectConfigurations(Consumer<ProtectConfigurationInformation.Builder> ... protectConfigurations) {
            this.protectConfigurations(Stream.of(protectConfigurations).map(c -> (ProtectConfigurationInformation)((ProtectConfigurationInformation.Builder)ProtectConfigurationInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProtectConfigurationsResponse build() {
            return new DescribeProtectConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProtectConfigurationsResponse> {
        public Builder protectConfigurations(Collection<ProtectConfigurationInformation> var1);

        public Builder protectConfigurations(ProtectConfigurationInformation ... var1);

        public Builder protectConfigurations(Consumer<ProtectConfigurationInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

