/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ContextMapCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MediaUrlListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMediaMessageRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, SendMediaMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::destinationPhoneNumber)).setter(SendMediaMessageRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::originationIdentity)).setter(SendMediaMessageRequest.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageBody").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::messageBody)).setter(SendMediaMessageRequest.setter(Builder::messageBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()}).build();
    private static final SdkField<List<String>> MEDIA_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaUrls").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::mediaUrls)).setter(SendMediaMessageRequest.setter(Builder::mediaUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::configurationSetName)).setter(SendMediaMessageRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPrice").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::maxPrice)).setter(SendMediaMessageRequest.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeToLive").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::timeToLive)).setter(SendMediaMessageRequest.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::context)).setter(SendMediaMessageRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::dryRun)).setter(SendMediaMessageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::protectConfigurationId)).setter(SendMediaMessageRequest.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<Boolean> MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MessageFeedbackEnabled").getter(SendMediaMessageRequest.getter(SendMediaMessageRequest::messageFeedbackEnabled)).setter(SendMediaMessageRequest.setter(Builder::messageFeedbackEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MEDIA_URLS_FIELD, CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD, DRY_RUN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, MESSAGE_FEEDBACK_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendMediaMessageRequest.memberNameToFieldInitializer();
    private final String destinationPhoneNumber;
    private final String originationIdentity;
    private final String messageBody;
    private final List<String> mediaUrls;
    private final String configurationSetName;
    private final String maxPrice;
    private final Integer timeToLive;
    private final Map<String, String> context;
    private final Boolean dryRun;
    private final String protectConfigurationId;
    private final Boolean messageFeedbackEnabled;

    private SendMediaMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.mediaUrls = builder.mediaUrls;
        this.configurationSetName = builder.configurationSetName;
        this.maxPrice = builder.maxPrice;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.messageFeedbackEnabled = builder.messageFeedbackEnabled;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final String messageBody() {
        return this.messageBody;
    }

    public final boolean hasMediaUrls() {
        return this.mediaUrls != null && !(this.mediaUrls instanceof SdkAutoConstructList);
    }

    public final List<String> mediaUrls() {
        return this.mediaUrls;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final String maxPrice() {
        return this.maxPrice;
    }

    public final Integer timeToLive() {
        return this.timeToLive;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final Boolean messageFeedbackEnabled() {
        return this.messageFeedbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaUrls() ? this.mediaUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFeedbackEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMediaMessageRequest)) {
            return false;
        }
        SendMediaMessageRequest other = (SendMediaMessageRequest)((Object)obj);
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && Objects.equals(this.messageBody(), other.messageBody()) && this.hasMediaUrls() == other.hasMediaUrls() && Objects.equals(this.mediaUrls(), other.mediaUrls()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.timeToLive(), other.timeToLive()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && Objects.equals(this.messageFeedbackEnabled(), other.messageFeedbackEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"SendMediaMessageRequest").add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("OriginationIdentity", (Object)this.originationIdentity()).add("MessageBody", (Object)this.messageBody()).add("MediaUrls", this.hasMediaUrls() ? this.mediaUrls() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).add("MaxPrice", (Object)this.maxPrice()).add("TimeToLive", (Object)this.timeToLive()).add("Context", this.hasContext() ? this.context() : null).add("DryRun", (Object)this.dryRun()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("MessageFeedbackEnabled", (Object)this.messageFeedbackEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "MessageBody": {
                return Optional.ofNullable(clazz.cast(this.messageBody()));
            }
            case "MediaUrls": {
                return Optional.ofNullable(clazz.cast(this.mediaUrls()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "MessageFeedbackEnabled": {
                return Optional.ofNullable(clazz.cast(this.messageFeedbackEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("MessageBody", MESSAGE_BODY_FIELD);
        map.put("MediaUrls", MEDIA_URLS_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("TimeToLive", TIME_TO_LIVE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("MessageFeedbackEnabled", MESSAGE_FEEDBACK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMediaMessageRequest, T> g) {
        return obj -> g.apply((SendMediaMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private String originationIdentity;
        private String messageBody;
        private List<String> mediaUrls = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;
        private String maxPrice;
        private Integer timeToLive;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Boolean dryRun;
        private String protectConfigurationId;
        private Boolean messageFeedbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMediaMessageRequest model) {
            super(model);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.originationIdentity(model.originationIdentity);
            this.messageBody(model.messageBody);
            this.mediaUrls(model.mediaUrls);
            this.configurationSetName(model.configurationSetName);
            this.maxPrice(model.maxPrice);
            this.timeToLive(model.timeToLive);
            this.context(model.context);
            this.dryRun(model.dryRun);
            this.protectConfigurationId(model.protectConfigurationId);
            this.messageFeedbackEnabled(model.messageFeedbackEnabled);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final Collection<String> getMediaUrls() {
            if (this.mediaUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mediaUrls;
        }

        public final void setMediaUrls(Collection<String> mediaUrls) {
            this.mediaUrls = MediaUrlListCopier.copy(mediaUrls);
        }

        @Override
        public final Builder mediaUrls(Collection<String> mediaUrls) {
            this.mediaUrls = MediaUrlListCopier.copy(mediaUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaUrls(String ... mediaUrls) {
            this.mediaUrls(Arrays.asList(mediaUrls));
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Boolean getMessageFeedbackEnabled() {
            return this.messageFeedbackEnabled;
        }

        public final void setMessageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
        }

        @Override
        public final Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMediaMessageRequest build() {
            return new SendMediaMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMediaMessageRequest> {
        public Builder destinationPhoneNumber(String var1);

        public Builder originationIdentity(String var1);

        public Builder messageBody(String var1);

        public Builder mediaUrls(Collection<String> var1);

        public Builder mediaUrls(String ... var1);

        public Builder configurationSetName(String var1);

        public Builder maxPrice(String var1);

        public Builder timeToLive(Integer var1);

        public Builder context(Map<String, String> var1);

        public Builder dryRun(Boolean var1);

        public Builder protectConfigurationId(String var1);

        public Builder messageFeedbackEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

