/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadataListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoolOriginationIdentitiesResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, ListPoolOriginationIdentitiesResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(ListPoolOriginationIdentitiesResponse.getter(ListPoolOriginationIdentitiesResponse::poolArn)).setter(ListPoolOriginationIdentitiesResponse.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(ListPoolOriginationIdentitiesResponse.getter(ListPoolOriginationIdentitiesResponse::poolId)).setter(ListPoolOriginationIdentitiesResponse.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<List<OriginationIdentityMetadata>> ORIGINATION_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OriginationIdentities").getter(ListPoolOriginationIdentitiesResponse.getter(ListPoolOriginationIdentitiesResponse::originationIdentities)).setter(ListPoolOriginationIdentitiesResponse.setter(Builder::originationIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OriginationIdentityMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPoolOriginationIdentitiesResponse.getter(ListPoolOriginationIdentitiesResponse::nextToken)).setter(ListPoolOriginationIdentitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD, ORIGINATION_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPoolOriginationIdentitiesResponse.memberNameToFieldInitializer();
    private final String poolArn;
    private final String poolId;
    private final List<OriginationIdentityMetadata> originationIdentities;
    private final String nextToken;

    private ListPoolOriginationIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.originationIdentities = builder.originationIdentities;
        this.nextToken = builder.nextToken;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final boolean hasOriginationIdentities() {
        return this.originationIdentities != null && !(this.originationIdentities instanceof SdkAutoConstructList);
    }

    public final List<OriginationIdentityMetadata> originationIdentities() {
        return this.originationIdentities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOriginationIdentities() ? this.originationIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoolOriginationIdentitiesResponse)) {
            return false;
        }
        ListPoolOriginationIdentitiesResponse other = (ListPoolOriginationIdentitiesResponse)((Object)obj);
        return Objects.equals(this.poolArn(), other.poolArn()) && Objects.equals(this.poolId(), other.poolId()) && this.hasOriginationIdentities() == other.hasOriginationIdentities() && Objects.equals(this.originationIdentities(), other.originationIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPoolOriginationIdentitiesResponse").add("PoolArn", (Object)this.poolArn()).add("PoolId", (Object)this.poolId()).add("OriginationIdentities", this.hasOriginationIdentities() ? this.originationIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "OriginationIdentities": {
                return Optional.ofNullable(clazz.cast(this.originationIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("OriginationIdentities", ORIGINATION_IDENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoolOriginationIdentitiesResponse, T> g) {
        return obj -> g.apply((ListPoolOriginationIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String poolArn;
        private String poolId;
        private List<OriginationIdentityMetadata> originationIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoolOriginationIdentitiesResponse model) {
            super(model);
            this.poolArn(model.poolArn);
            this.poolId(model.poolId);
            this.originationIdentities(model.originationIdentities);
            this.nextToken(model.nextToken);
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final List<OriginationIdentityMetadata.Builder> getOriginationIdentities() {
            List<OriginationIdentityMetadata.Builder> result = OriginationIdentityMetadataListCopier.copyToBuilder(this.originationIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOriginationIdentities(Collection<OriginationIdentityMetadata.BuilderImpl> originationIdentities) {
            this.originationIdentities = OriginationIdentityMetadataListCopier.copyFromBuilder(originationIdentities);
        }

        @Override
        public final Builder originationIdentities(Collection<OriginationIdentityMetadata> originationIdentities) {
            this.originationIdentities = OriginationIdentityMetadataListCopier.copy(originationIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originationIdentities(OriginationIdentityMetadata ... originationIdentities) {
            this.originationIdentities(Arrays.asList(originationIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originationIdentities(Consumer<OriginationIdentityMetadata.Builder> ... originationIdentities) {
            this.originationIdentities(Stream.of(originationIdentities).map(c -> (OriginationIdentityMetadata)((OriginationIdentityMetadata.Builder)OriginationIdentityMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPoolOriginationIdentitiesResponse build() {
            return new ListPoolOriginationIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoolOriginationIdentitiesResponse> {
        public Builder poolArn(String var1);

        public Builder poolId(String var1);

        public Builder originationIdentities(Collection<OriginationIdentityMetadata> var1);

        public Builder originationIdentities(OriginationIdentityMetadata ... var1);

        public Builder originationIdentities(Consumer<OriginationIdentityMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

