/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NumberType {
    SHORT_CODE("SHORT_CODE"),
    LONG_CODE("LONG_CODE"),
    TOLL_FREE("TOLL_FREE"),
    TEN_DLC("TEN_DLC"),
    SIMULATOR("SIMULATOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NumberType> VALUE_MAP;
    private final String value;

    private NumberType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumberType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumberType> knownValues() {
        EnumSet<NumberType> knownValues = EnumSet.allOf(NumberType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NumberType.class, NumberType::toString);
    }
}

