/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation;

public class DescribeSenderIdsIterable
implements SdkIterable<DescribeSenderIdsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeSenderIdsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSenderIdsIterable(PinpointSmsVoiceV2Client client, DescribeSenderIdsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSenderIdsResponseFetcher();
    }

    public Iterator<DescribeSenderIdsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SenderIdInformation> senderIds() {
        Function<DescribeSenderIdsResponse, Iterator> getIterator = response -> {
            if (response != null && response.senderIds() != null) {
                return response.senderIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSenderIdsResponseFetcher
    implements SyncPageFetcher<DescribeSenderIdsResponse> {
        private DescribeSenderIdsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSenderIdsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSenderIdsResponse nextPage(DescribeSenderIdsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSenderIdsIterable.this.client.describeSenderIds(DescribeSenderIdsIterable.this.firstRequest);
            }
            return DescribeSenderIdsIterable.this.client.describeSenderIds((DescribeSenderIdsRequest)((Object)DescribeSenderIdsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

