/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationsResponse> {
    private static final SdkField<List<RegistrationInformation>> REGISTRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Registrations").getter(DescribeRegistrationsResponse.getter(DescribeRegistrationsResponse::registrations)).setter(DescribeRegistrationsResponse.setter(Builder::registrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationsResponse.getter(DescribeRegistrationsResponse::nextToken)).setter(DescribeRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Registrations", REGISTRATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RegistrationInformation> registrations;
    private final String nextToken;

    private DescribeRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.registrations = builder.registrations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRegistrations() {
        return this.registrations != null && !(this.registrations instanceof SdkAutoConstructList);
    }

    public final List<RegistrationInformation> registrations() {
        return this.registrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrations() ? this.registrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationsResponse)) {
            return false;
        }
        DescribeRegistrationsResponse other = (DescribeRegistrationsResponse)((Object)obj);
        return this.hasRegistrations() == other.hasRegistrations() && Objects.equals(this.registrations(), other.registrations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationsResponse").add("Registrations", this.hasRegistrations() ? this.registrations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Registrations": {
                return Optional.ofNullable(clazz.cast(this.registrations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<RegistrationInformation> registrations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationsResponse model) {
            super(model);
            this.registrations(model.registrations);
            this.nextToken(model.nextToken);
        }

        public final List<RegistrationInformation.Builder> getRegistrations() {
            List<RegistrationInformation.Builder> result = RegistrationInformationListCopier.copyToBuilder(this.registrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrations(Collection<RegistrationInformation.BuilderImpl> registrations) {
            this.registrations = RegistrationInformationListCopier.copyFromBuilder(registrations);
        }

        @Override
        public final Builder registrations(Collection<RegistrationInformation> registrations) {
            this.registrations = RegistrationInformationListCopier.copy(registrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrations(RegistrationInformation ... registrations) {
            this.registrations(Arrays.asList(registrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrations(Consumer<RegistrationInformation.Builder> ... registrations) {
            this.registrations(Stream.of(registrations).map(c -> (RegistrationInformation)((RegistrationInformation.Builder)RegistrationInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationsResponse build() {
            return new DescribeRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationsResponse> {
        public Builder registrations(Collection<RegistrationInformation> var1);

        public Builder registrations(RegistrationInformation ... var1);

        public Builder registrations(Consumer<RegistrationInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

