/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeDefinition;

public class DescribeRegistrationTypeDefinitionsIterable
implements SdkIterable<DescribeRegistrationTypeDefinitionsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationTypeDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationTypeDefinitionsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationTypeDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationTypeDefinitionsResponseFetcher();
    }

    public Iterator<DescribeRegistrationTypeDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationTypeDefinition> registrationTypeDefinitions() {
        Function<DescribeRegistrationTypeDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationTypeDefinitions() != null) {
                return response.registrationTypeDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationTypeDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationTypeDefinitionsResponse> {
        private DescribeRegistrationTypeDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationTypeDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationTypeDefinitionsResponse nextPage(DescribeRegistrationTypeDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationTypeDefinitionsIterable.this.client.describeRegistrationTypeDefinitions(DescribeRegistrationTypeDefinitionsIterable.this.firstRequest);
            }
            return DescribeRegistrationTypeDefinitionsIterable.this.client.describeRegistrationTypeDefinitions((DescribeRegistrationTypeDefinitionsRequest)((Object)DescribeRegistrationTypeDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

