/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoice.model.PinpointSmsVoiceRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.VoiceMessageContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendVoiceMessageRequest
extends PinpointSmsVoiceRequest
implements ToCopyableBuilder<Builder, SendVoiceMessageRequest> {
    private static final SdkField<String> CALLER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::callerId)).setter(SendVoiceMessageRequest.setter(Builder::callerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerId").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::configurationSetName)).setter(SendVoiceMessageRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<VoiceMessageContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::content)).setter(SendVoiceMessageRequest.setter(Builder::content)).constructor(VoiceMessageContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::destinationPhoneNumber)).setter(SendVoiceMessageRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::originationPhoneNumber)).setter(SendVoiceMessageRequest.setter(Builder::originationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationPhoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_ID_FIELD, CONFIGURATION_SET_NAME_FIELD, CONTENT_FIELD, DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_PHONE_NUMBER_FIELD));
    private final String callerId;
    private final String configurationSetName;
    private final VoiceMessageContent content;
    private final String destinationPhoneNumber;
    private final String originationPhoneNumber;

    private SendVoiceMessageRequest(BuilderImpl builder) {
        super(builder);
        this.callerId = builder.callerId;
        this.configurationSetName = builder.configurationSetName;
        this.content = builder.content;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationPhoneNumber = builder.originationPhoneNumber;
    }

    public String callerId() {
        return this.callerId;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public VoiceMessageContent content() {
        return this.content;
    }

    public String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public String originationPhoneNumber() {
        return this.originationPhoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationPhoneNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendVoiceMessageRequest)) {
            return false;
        }
        SendVoiceMessageRequest other = (SendVoiceMessageRequest)((Object)obj);
        return Objects.equals(this.callerId(), other.callerId()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.originationPhoneNumber(), other.originationPhoneNumber());
    }

    public String toString() {
        return ToString.builder((String)"SendVoiceMessageRequest").add("CallerId", (Object)this.callerId()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("Content", (Object)this.content()).add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("OriginationPhoneNumber", (Object)this.originationPhoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerId": {
                return Optional.ofNullable(clazz.cast(this.callerId()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "OriginationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.originationPhoneNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendVoiceMessageRequest, T> g) {
        return obj -> g.apply((SendVoiceMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceRequest.BuilderImpl
    implements Builder {
        private String callerId;
        private String configurationSetName;
        private VoiceMessageContent content;
        private String destinationPhoneNumber;
        private String originationPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendVoiceMessageRequest model) {
            super(model);
            this.callerId(model.callerId);
            this.configurationSetName(model.configurationSetName);
            this.content(model.content);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.originationPhoneNumber(model.originationPhoneNumber);
        }

        public final String getCallerId() {
            return this.callerId;
        }

        @Override
        public final Builder callerId(String callerId) {
            this.callerId = callerId;
            return this;
        }

        public final void setCallerId(String callerId) {
            this.callerId = callerId;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final VoiceMessageContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        @Override
        public final Builder content(VoiceMessageContent content) {
            this.content = content;
            return this;
        }

        public final void setContent(VoiceMessageContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        public final String getOriginationPhoneNumber() {
            return this.originationPhoneNumber;
        }

        @Override
        public final Builder originationPhoneNumber(String originationPhoneNumber) {
            this.originationPhoneNumber = originationPhoneNumber;
            return this;
        }

        public final void setOriginationPhoneNumber(String originationPhoneNumber) {
            this.originationPhoneNumber = originationPhoneNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendVoiceMessageRequest build() {
            return new SendVoiceMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendVoiceMessageRequest> {
        public Builder callerId(String var1);

        public Builder configurationSetName(String var1);

        public Builder content(VoiceMessageContent var1);

        default public Builder content(Consumer<VoiceMessageContent.Builder> content) {
            return this.content((VoiceMessageContent)((VoiceMessageContent.Builder)VoiceMessageContent.builder().applyMutation(content)).build());
        }

        public Builder destinationPhoneNumber(String var1);

        public Builder originationPhoneNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

