/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoice.model.ConfigurationSetsCopier;
import software.amazon.awssdk.services.pinpointsmsvoice.model.PinpointSmsVoiceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationSetsResponse
extends PinpointSmsVoiceResponse
implements ToCopyableBuilder<Builder, ListConfigurationSetsResponse> {
    private static final SdkField<List<String>> CONFIGURATION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationSets").getter(ListConfigurationSetsResponse.getter(ListConfigurationSetsResponse::configurationSets)).setter(ListConfigurationSetsResponse.setter(Builder::configurationSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationSetsResponse.getter(ListConfigurationSetsResponse::nextToken)).setter(ListConfigurationSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> configurationSets;
    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConfigurationSets() {
        return this.configurationSets != null && !(this.configurationSets instanceof SdkAutoConstructList);
    }

    public List<String> configurationSets() {
        return this.configurationSets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse)((Object)obj);
        return Objects.equals(this.configurationSets(), other.configurationSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConfigurationSetsResponse").add("ConfigurationSets", this.configurationSets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSets": {
                return Optional.ofNullable(clazz.cast(this.configurationSets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationSetsResponse, T> g) {
        return obj -> g.apply((ListConfigurationSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceResponse.BuilderImpl
    implements Builder {
        private List<String> configurationSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            super(model);
            this.configurationSets(model.configurationSets);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConfigurationSets() {
            return this.configurationSets;
        }

        @Override
        public final Builder configurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(String ... configurationSets) {
            this.configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        public final void setConfigurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        public Builder configurationSets(Collection<String> var1);

        public Builder configurationSets(String ... var1);

        public Builder nextToken(String var1);
    }
}

