/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.model.AccountSuspendedException;
import software.amazon.awssdk.services.pinpointemail.model.AlreadyExistsException;
import software.amazon.awssdk.services.pinpointemail.model.BadRequestException;
import software.amazon.awssdk.services.pinpointemail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.pinpointemail.model.LimitExceededException;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.pinpointemail.model.MessageRejectedException;
import software.amazon.awssdk.services.pinpointemail.model.NotFoundException;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailException;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendingPausedException;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointemail.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointemail.paginators.GetDedicatedIpsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListConfigurationSetsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListDedicatedIpPoolsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListDeliverabilityTestReportsIterable;
import software.amazon.awssdk.services.pinpointemail.paginators.ListEmailIdentitiesIterable;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointemail.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;

@SdkInternalApi
final class DefaultPinpointEmailClient
implements PinpointEmailClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointEmailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ses";
    }

    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetRequest).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDedicatedIpPoolResponse createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDedicatedIpPoolRequest).withMarshaller((Marshaller)new CreateDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) throws AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeliverabilityTestReportRequest).withMarshaller((Marshaller)new CreateDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateEmailIdentityResponse createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest) throws LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEmailIdentityRequest).withMarshaller((Marshaller)new CreateEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetRequest).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDedicatedIpPoolRequest).withMarshaller((Marshaller)new DeleteDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEmailIdentityResponse deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEmailIdentityRequest).withMarshaller((Marshaller)new DeleteEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountRequest).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBlacklistReportsResponse getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlacklistReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBlacklistReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlacklistReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBlacklistReportsRequest).withMarshaller((Marshaller)new GetBlacklistReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetConfigurationSetResponse getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetRequest).withMarshaller((Marshaller)new GetConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetConfigurationSetEventDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSetEventDestinations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetEventDestinationsRequest).withMarshaller((Marshaller)new GetConfigurationSetEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpResponse getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDedicatedIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpRequest).withMarshaller((Marshaller)new GetDedicatedIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpsResponse getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDedicatedIpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpsRequest).withMarshaller((Marshaller)new GetDedicatedIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpsIterable getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new GetDedicatedIpsIterable(this, this.applyPaginatorUserAgent(getDedicatedIpsRequest));
    }

    @Override
    public GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) throws TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDeliverabilityDashboardOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityDashboardOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityDashboardOptionsRequest).withMarshaller((Marshaller)new GetDeliverabilityDashboardOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDeliverabilityTestReportResponse getDeliverabilityTestReport(GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityTestReportRequest).withMarshaller((Marshaller)new GetDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainStatisticsReportResponse getDomainStatisticsReport(GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainStatisticsReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainStatisticsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainStatisticsReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainStatisticsReportRequest).withMarshaller((Marshaller)new GetDomainStatisticsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEmailIdentityResponse getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEmailIdentityRequest).withMarshaller((Marshaller)new GetEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationSetsRequest).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListConfigurationSetsIterable listConfigurationSetsPaginator(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListConfigurationSetsIterable(this, this.applyPaginatorUserAgent(listConfigurationSetsRequest));
    }

    @Override
    public ListDedicatedIpPoolsResponse listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDedicatedIpPoolsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDedicatedIpPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDedicatedIpPools").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDedicatedIpPoolsRequest).withMarshaller((Marshaller)new ListDedicatedIpPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDedicatedIpPoolsIterable listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListDedicatedIpPoolsIterable(this, this.applyPaginatorUserAgent(listDedicatedIpPoolsRequest));
    }

    @Override
    public ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeliverabilityTestReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDeliverabilityTestReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeliverabilityTestReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeliverabilityTestReportsRequest).withMarshaller((Marshaller)new ListDeliverabilityTestReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDeliverabilityTestReportsIterable listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListDeliverabilityTestReportsIterable(this, this.applyPaginatorUserAgent(listDeliverabilityTestReportsRequest));
    }

    @Override
    public ListEmailIdentitiesResponse listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEmailIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEmailIdentitiesRequest).withMarshaller((Marshaller)new ListEmailIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEmailIdentitiesIterable listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        return new ListEmailIdentitiesIterable(this, this.applyPaginatorUserAgent(listEmailIdentitiesRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutAccountDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest).withMarshaller((Marshaller)new PutAccountDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutAccountSendingAttributesResponse putAccountSendingAttributes(PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSendingAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutAccountSendingAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSendingAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountSendingAttributesRequest).withMarshaller((Marshaller)new PutAccountSendingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetDeliveryOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetReputationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetReputationOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetReputationOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetReputationOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetSendingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSendingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetSendingOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetSendingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetTrackingOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetTrackingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDedicatedIpInPoolResponse putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpInPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDedicatedIpInPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpInPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpInPoolRequest).withMarshaller((Marshaller)new PutDedicatedIpInPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpWarmupAttributesRequest).withMarshaller((Marshaller)new PutDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDeliverabilityDashboardOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverabilityDashboardOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDeliverabilityDashboardOptionRequest).withMarshaller((Marshaller)new PutDeliverabilityDashboardOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityDkimAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityDkimAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityFeedbackAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityFeedbackAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityFeedbackAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityFeedbackAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityMailFromAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityMailFromAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityMailFromAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityMailFromAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendEmailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendEmailRequest).withMarshaller((Marshaller)new SendEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, PinpointEmailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PinpointEmailException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SendingPausedException").exceptionBuilderSupplier(SendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSuspendedException").exceptionBuilderSupplier(AccountSuspendedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends PinpointEmailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.24").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PinpointEmailRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

