/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.pinpointemail.model.ListEmailIdentitiesResponse;

public class ListEmailIdentitiesPublisher
implements SdkPublisher<ListEmailIdentitiesResponse> {
    private final PinpointEmailAsyncClient client;
    private final ListEmailIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEmailIdentitiesPublisher(PinpointEmailAsyncClient client, ListEmailIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEmailIdentitiesPublisher(PinpointEmailAsyncClient client, ListEmailIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEmailIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEmailIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListEmailIdentitiesPublisher resume(ListEmailIdentitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEmailIdentitiesPublisher(this.client, (ListEmailIdentitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEmailIdentitiesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEmailIdentitiesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEmailIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListEmailIdentitiesResponse> {
        private ListEmailIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEmailIdentitiesResponse> nextPage(ListEmailIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEmailIdentitiesPublisher.this.client.listEmailIdentities(ListEmailIdentitiesPublisher.this.firstRequest);
            }
            return ListEmailIdentitiesPublisher.this.client.listEmailIdentities((ListEmailIdentitiesRequest)((Object)ListEmailIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

