/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.BlacklistItemNamesCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlacklistReportsRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, GetBlacklistReportsRequest> {
    private static final SdkField<List<String>> BLACKLIST_ITEM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlacklistItemNames").getter(GetBlacklistReportsRequest.getter(GetBlacklistReportsRequest::blacklistItemNames)).setter(GetBlacklistReportsRequest.setter(Builder::blacklistItemNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("BlacklistItemNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_ITEM_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlacklistReportsRequest.memberNameToFieldInitializer();
    private final List<String> blacklistItemNames;

    private GetBlacklistReportsRequest(BuilderImpl builder) {
        super(builder);
        this.blacklistItemNames = builder.blacklistItemNames;
    }

    public final boolean hasBlacklistItemNames() {
        return this.blacklistItemNames != null && !(this.blacklistItemNames instanceof SdkAutoConstructList);
    }

    public final List<String> blacklistItemNames() {
        return this.blacklistItemNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlacklistItemNames() ? this.blacklistItemNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlacklistReportsRequest)) {
            return false;
        }
        GetBlacklistReportsRequest other = (GetBlacklistReportsRequest)((Object)obj);
        return this.hasBlacklistItemNames() == other.hasBlacklistItemNames() && Objects.equals(this.blacklistItemNames(), other.blacklistItemNames());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlacklistReportsRequest").add("BlacklistItemNames", this.hasBlacklistItemNames() ? this.blacklistItemNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlacklistItemNames": {
                return Optional.ofNullable(clazz.cast(this.blacklistItemNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("BlacklistItemNames", BLACKLIST_ITEM_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlacklistReportsRequest, T> g) {
        return obj -> g.apply((GetBlacklistReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private List<String> blacklistItemNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlacklistReportsRequest model) {
            super(model);
            this.blacklistItemNames(model.blacklistItemNames);
        }

        public final Collection<String> getBlacklistItemNames() {
            if (this.blacklistItemNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blacklistItemNames;
        }

        public final void setBlacklistItemNames(Collection<String> blacklistItemNames) {
            this.blacklistItemNames = BlacklistItemNamesCopier.copy(blacklistItemNames);
        }

        @Override
        public final Builder blacklistItemNames(Collection<String> blacklistItemNames) {
            this.blacklistItemNames = BlacklistItemNamesCopier.copy(blacklistItemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blacklistItemNames(String ... blacklistItemNames) {
            this.blacklistItemNames(Arrays.asList(blacklistItemNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlacklistReportsRequest build() {
            return new GetBlacklistReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlacklistReportsRequest> {
        public Builder blacklistItemNames(Collection<String> var1);

        public Builder blacklistItemNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

