/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.services.pinpointemail.model.TlsPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetDeliveryOptionsRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutConfigurationSetDeliveryOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(PutConfigurationSetDeliveryOptionsRequest.getter(PutConfigurationSetDeliveryOptionsRequest::configurationSetName)).setter(PutConfigurationSetDeliveryOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> TLS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsPolicy").getter(PutConfigurationSetDeliveryOptionsRequest.getter(PutConfigurationSetDeliveryOptionsRequest::tlsPolicyAsString)).setter(PutConfigurationSetDeliveryOptionsRequest.setter(Builder::tlsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsPolicy").build()}).build();
    private static final SdkField<String> SENDING_POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SendingPoolName").getter(PutConfigurationSetDeliveryOptionsRequest.getter(PutConfigurationSetDeliveryOptionsRequest::sendingPoolName)).setter(PutConfigurationSetDeliveryOptionsRequest.setter(Builder::sendingPoolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingPoolName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, TLS_POLICY_FIELD, SENDING_POOL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutConfigurationSetDeliveryOptionsRequest.memberNameToFieldInitializer();
    private final String configurationSetName;
    private final String tlsPolicy;
    private final String sendingPoolName;

    private PutConfigurationSetDeliveryOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.tlsPolicy = builder.tlsPolicy;
        this.sendingPoolName = builder.sendingPoolName;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(this.tlsPolicy);
    }

    public final String tlsPolicyAsString() {
        return this.tlsPolicy;
    }

    public final String sendingPoolName() {
        return this.sendingPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingPoolName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetDeliveryOptionsRequest)) {
            return false;
        }
        PutConfigurationSetDeliveryOptionsRequest other = (PutConfigurationSetDeliveryOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.tlsPolicyAsString(), other.tlsPolicyAsString()) && Objects.equals(this.sendingPoolName(), other.sendingPoolName());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfigurationSetDeliveryOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("TlsPolicy", (Object)this.tlsPolicyAsString()).add("SendingPoolName", (Object)this.sendingPoolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "TlsPolicy": {
                return Optional.ofNullable(clazz.cast(this.tlsPolicyAsString()));
            }
            case "SendingPoolName": {
                return Optional.ofNullable(clazz.cast(this.sendingPoolName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("TlsPolicy", TLS_POLICY_FIELD);
        map.put("SendingPoolName", SENDING_POOL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetDeliveryOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetDeliveryOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String tlsPolicy;
        private String sendingPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetDeliveryOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.tlsPolicy(model.tlsPolicy);
            this.sendingPoolName(model.sendingPoolName);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getTlsPolicy() {
            return this.tlsPolicy;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy == null ? null : tlsPolicy.toString());
            return this;
        }

        public final String getSendingPoolName() {
            return this.sendingPoolName;
        }

        public final void setSendingPoolName(String sendingPoolName) {
            this.sendingPoolName = sendingPoolName;
        }

        @Override
        public final Builder sendingPoolName(String sendingPoolName) {
            this.sendingPoolName = sendingPoolName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetDeliveryOptionsRequest build() {
            return new PutConfigurationSetDeliveryOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetDeliveryOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder tlsPolicy(String var1);

        public Builder tlsPolicy(TlsPolicy var1);

        public Builder sendingPoolName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

