/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetReputationOptionsRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutConfigurationSetReputationOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(PutConfigurationSetReputationOptionsRequest.getter(PutConfigurationSetReputationOptionsRequest::configurationSetName)).setter(PutConfigurationSetReputationOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<Boolean> REPUTATION_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReputationMetricsEnabled").getter(PutConfigurationSetReputationOptionsRequest.getter(PutConfigurationSetReputationOptionsRequest::reputationMetricsEnabled)).setter(PutConfigurationSetReputationOptionsRequest.setter(Builder::reputationMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationMetricsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, REPUTATION_METRICS_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
            this.put("ReputationMetricsEnabled", REPUTATION_METRICS_ENABLED_FIELD);
        }
    });
    private final String configurationSetName;
    private final Boolean reputationMetricsEnabled;

    private PutConfigurationSetReputationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.reputationMetricsEnabled = builder.reputationMetricsEnabled;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final Boolean reputationMetricsEnabled() {
        return this.reputationMetricsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationMetricsEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetReputationOptionsRequest)) {
            return false;
        }
        PutConfigurationSetReputationOptionsRequest other = (PutConfigurationSetReputationOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.reputationMetricsEnabled(), other.reputationMetricsEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfigurationSetReputationOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("ReputationMetricsEnabled", (Object)this.reputationMetricsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "ReputationMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.reputationMetricsEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetReputationOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetReputationOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private Boolean reputationMetricsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetReputationOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.reputationMetricsEnabled(model.reputationMetricsEnabled);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Boolean getReputationMetricsEnabled() {
            return this.reputationMetricsEnabled;
        }

        public final void setReputationMetricsEnabled(Boolean reputationMetricsEnabled) {
            this.reputationMetricsEnabled = reputationMetricsEnabled;
        }

        @Override
        public final Builder reputationMetricsEnabled(Boolean reputationMetricsEnabled) {
            this.reputationMetricsEnabled = reputationMetricsEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetReputationOptionsRequest build() {
            return new PutConfigurationSetReputationOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetReputationOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder reputationMetricsEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

