/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption;
import software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOptionsCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeliverabilityDashboardOptionRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutDeliverabilityDashboardOptionRequest> {
    private static final SdkField<Boolean> DASHBOARD_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DashboardEnabled").getter(PutDeliverabilityDashboardOptionRequest.getter(PutDeliverabilityDashboardOptionRequest::dashboardEnabled)).setter(PutDeliverabilityDashboardOptionRequest.setter(Builder::dashboardEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardEnabled").build()}).build();
    private static final SdkField<List<DomainDeliverabilityTrackingOption>> SUBSCRIBED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubscribedDomains").getter(PutDeliverabilityDashboardOptionRequest.getter(PutDeliverabilityDashboardOptionRequest::subscribedDomains)).setter(PutDeliverabilityDashboardOptionRequest.setter(Builder::subscribedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainDeliverabilityTrackingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ENABLED_FIELD, SUBSCRIBED_DOMAINS_FIELD));
    private final Boolean dashboardEnabled;
    private final List<DomainDeliverabilityTrackingOption> subscribedDomains;

    private PutDeliverabilityDashboardOptionRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardEnabled = builder.dashboardEnabled;
        this.subscribedDomains = builder.subscribedDomains;
    }

    public final Boolean dashboardEnabled() {
        return this.dashboardEnabled;
    }

    public final boolean hasSubscribedDomains() {
        return this.subscribedDomains != null && !(this.subscribedDomains instanceof SdkAutoConstructList);
    }

    public final List<DomainDeliverabilityTrackingOption> subscribedDomains() {
        return this.subscribedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedDomains() ? this.subscribedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliverabilityDashboardOptionRequest)) {
            return false;
        }
        PutDeliverabilityDashboardOptionRequest other = (PutDeliverabilityDashboardOptionRequest)((Object)obj);
        return Objects.equals(this.dashboardEnabled(), other.dashboardEnabled()) && this.hasSubscribedDomains() == other.hasSubscribedDomains() && Objects.equals(this.subscribedDomains(), other.subscribedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"PutDeliverabilityDashboardOptionRequest").add("DashboardEnabled", (Object)this.dashboardEnabled()).add("SubscribedDomains", this.hasSubscribedDomains() ? this.subscribedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardEnabled": {
                return Optional.ofNullable(clazz.cast(this.dashboardEnabled()));
            }
            case "SubscribedDomains": {
                return Optional.ofNullable(clazz.cast(this.subscribedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliverabilityDashboardOptionRequest, T> g) {
        return obj -> g.apply((PutDeliverabilityDashboardOptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private Boolean dashboardEnabled;
        private List<DomainDeliverabilityTrackingOption> subscribedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliverabilityDashboardOptionRequest model) {
            super(model);
            this.dashboardEnabled(model.dashboardEnabled);
            this.subscribedDomains(model.subscribedDomains);
        }

        public final Boolean getDashboardEnabled() {
            return this.dashboardEnabled;
        }

        public final void setDashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
        }

        @Override
        @Transient
        public final Builder dashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
            return this;
        }

        public final List<DomainDeliverabilityTrackingOption.Builder> getSubscribedDomains() {
            List<DomainDeliverabilityTrackingOption.Builder> result = DomainDeliverabilityTrackingOptionsCopier.copyToBuilder(this.subscribedDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedDomains(Collection<DomainDeliverabilityTrackingOption.BuilderImpl> subscribedDomains) {
            this.subscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copyFromBuilder(subscribedDomains);
        }

        @Override
        @Transient
        public final Builder subscribedDomains(Collection<DomainDeliverabilityTrackingOption> subscribedDomains) {
            this.subscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copy(subscribedDomains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribedDomains(DomainDeliverabilityTrackingOption ... subscribedDomains) {
            this.subscribedDomains(Arrays.asList(subscribedDomains));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... subscribedDomains) {
            this.subscribedDomains(Stream.of(subscribedDomains).map(c -> (DomainDeliverabilityTrackingOption)((DomainDeliverabilityTrackingOption.Builder)DomainDeliverabilityTrackingOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliverabilityDashboardOptionRequest build() {
            return new PutDeliverabilityDashboardOptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeliverabilityDashboardOptionRequest> {
        public Builder dashboardEnabled(Boolean var1);

        public Builder subscribedDomains(Collection<DomainDeliverabilityTrackingOption> var1);

        public Builder subscribedDomains(DomainDeliverabilityTrackingOption ... var1);

        public Builder subscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

