/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.ListOfDedicatedIpPoolsCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDedicatedIpPoolsResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, ListDedicatedIpPoolsResponse> {
    private static final SdkField<List<String>> DEDICATED_IP_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DedicatedIpPools").getter(ListDedicatedIpPoolsResponse.getter(ListDedicatedIpPoolsResponse::dedicatedIpPools)).setter(ListDedicatedIpPoolsResponse.setter(Builder::dedicatedIpPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIpPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDedicatedIpPoolsResponse.getter(ListDedicatedIpPoolsResponse::nextToken)).setter(ListDedicatedIpPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_IP_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> dedicatedIpPools;
    private final String nextToken;

    private ListDedicatedIpPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedIpPools = builder.dedicatedIpPools;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDedicatedIpPools() {
        return this.dedicatedIpPools != null && !(this.dedicatedIpPools instanceof SdkAutoConstructList);
    }

    public List<String> dedicatedIpPools() {
        return this.dedicatedIpPools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDedicatedIpPools() ? this.dedicatedIpPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDedicatedIpPoolsResponse)) {
            return false;
        }
        ListDedicatedIpPoolsResponse other = (ListDedicatedIpPoolsResponse)((Object)obj);
        return this.hasDedicatedIpPools() == other.hasDedicatedIpPools() && Objects.equals(this.dedicatedIpPools(), other.dedicatedIpPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDedicatedIpPoolsResponse").add("DedicatedIpPools", this.hasDedicatedIpPools() ? this.dedicatedIpPools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DedicatedIpPools": {
                return Optional.ofNullable(clazz.cast(this.dedicatedIpPools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDedicatedIpPoolsResponse, T> g) {
        return obj -> g.apply((ListDedicatedIpPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private List<String> dedicatedIpPools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDedicatedIpPoolsResponse model) {
            super(model);
            this.dedicatedIpPools(model.dedicatedIpPools);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDedicatedIpPools() {
            if (this.dedicatedIpPools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dedicatedIpPools;
        }

        @Override
        public final Builder dedicatedIpPools(Collection<String> dedicatedIpPools) {
            this.dedicatedIpPools = ListOfDedicatedIpPoolsCopier.copy(dedicatedIpPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dedicatedIpPools(String ... dedicatedIpPools) {
            this.dedicatedIpPools(Arrays.asList(dedicatedIpPools));
            return this;
        }

        public final void setDedicatedIpPools(Collection<String> dedicatedIpPools) {
            this.dedicatedIpPools = ListOfDedicatedIpPoolsCopier.copy(dedicatedIpPools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDedicatedIpPoolsResponse build() {
            return new ListDedicatedIpPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDedicatedIpPoolsResponse> {
        public Builder dedicatedIpPools(Collection<String> var1);

        public Builder dedicatedIpPools(String ... var1);

        public Builder nextToken(String var1);
    }
}

