/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailClient;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse;

public class GetDedicatedIpsIterable
implements SdkIterable<GetDedicatedIpsResponse> {
    private final PinpointEmailClient client;
    private final GetDedicatedIpsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDedicatedIpsIterable(PinpointEmailClient client, GetDedicatedIpsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDedicatedIpsResponseFetcher();
    }

    public Iterator<GetDedicatedIpsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDedicatedIpsResponseFetcher
    implements SyncPageFetcher<GetDedicatedIpsResponse> {
        private GetDedicatedIpsResponseFetcher() {
        }

        public boolean hasNextPage(GetDedicatedIpsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDedicatedIpsResponse nextPage(GetDedicatedIpsResponse previousPage) {
            if (previousPage == null) {
                return GetDedicatedIpsIterable.this.client.getDedicatedIps(GetDedicatedIpsIterable.this.firstRequest);
            }
            return GetDedicatedIpsIterable.this.client.getDedicatedIps((GetDedicatedIpsRequest)((Object)GetDedicatedIpsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

