/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the results of a request to create or update an endpoint that's associated with an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemResponse implements SdkPojo, Serializable, ToCopyableBuilder<ItemResponse.Builder, ItemResponse> {
    private static final SdkField<EndpointItemResponse> ENDPOINT_ITEM_RESPONSE_FIELD = SdkField
            .<EndpointItemResponse> builder(MarshallingType.SDK_POJO).memberName("EndpointItemResponse")
            .getter(getter(ItemResponse::endpointItemResponse)).setter(setter(Builder::endpointItemResponse))
            .constructor(EndpointItemResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointItemResponse").build())
            .build();

    private static final SdkField<Map<String, EventItemResponse>> EVENTS_ITEM_RESPONSE_FIELD = SdkField
            .<Map<String, EventItemResponse>> builder(MarshallingType.MAP)
            .memberName("EventsItemResponse")
            .getter(getter(ItemResponse::eventsItemResponse))
            .setter(setter(Builder::eventsItemResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsItemResponse").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EventItemResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventItemResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ITEM_RESPONSE_FIELD,
            EVENTS_ITEM_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EndpointItemResponse endpointItemResponse;

    private final Map<String, EventItemResponse> eventsItemResponse;

    private ItemResponse(BuilderImpl builder) {
        this.endpointItemResponse = builder.endpointItemResponse;
        this.eventsItemResponse = builder.eventsItemResponse;
    }

    /**
     * <p>
     * The response that was received after the endpoint data was accepted.
     * </p>
     * 
     * @return The response that was received after the endpoint data was accepted.
     */
    public final EndpointItemResponse endpointItemResponse() {
        return endpointItemResponse;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventsItemResponse property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventsItemResponse() {
        return eventsItemResponse != null && !(eventsItemResponse instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A multipart response object that contains a key and a value for each event in the request. In each object, the
     * event ID is the key and an EventItemResponse object is the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventsItemResponse} method.
     * </p>
     * 
     * @return A multipart response object that contains a key and a value for each event in the request. In each
     *         object, the event ID is the key and an EventItemResponse object is the value.
     */
    public final Map<String, EventItemResponse> eventsItemResponse() {
        return eventsItemResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointItemResponse());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventsItemResponse() ? eventsItemResponse() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemResponse)) {
            return false;
        }
        ItemResponse other = (ItemResponse) obj;
        return Objects.equals(endpointItemResponse(), other.endpointItemResponse())
                && hasEventsItemResponse() == other.hasEventsItemResponse()
                && Objects.equals(eventsItemResponse(), other.eventsItemResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemResponse").add("EndpointItemResponse", endpointItemResponse())
                .add("EventsItemResponse", hasEventsItemResponse() ? eventsItemResponse() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointItemResponse":
            return Optional.ofNullable(clazz.cast(endpointItemResponse()));
        case "EventsItemResponse":
            return Optional.ofNullable(clazz.cast(eventsItemResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointItemResponse", ENDPOINT_ITEM_RESPONSE_FIELD);
        map.put("EventsItemResponse", EVENTS_ITEM_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemResponse, T> g) {
        return obj -> g.apply((ItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemResponse> {
        /**
         * <p>
         * The response that was received after the endpoint data was accepted.
         * </p>
         * 
         * @param endpointItemResponse
         *        The response that was received after the endpoint data was accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointItemResponse(EndpointItemResponse endpointItemResponse);

        /**
         * <p>
         * The response that was received after the endpoint data was accepted.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointItemResponse.Builder} avoiding
         * the need to create one manually via {@link EndpointItemResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointItemResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointItemResponse(EndpointItemResponse)}.
         * 
         * @param endpointItemResponse
         *        a consumer that will call methods on {@link EndpointItemResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointItemResponse(EndpointItemResponse)
         */
        default Builder endpointItemResponse(Consumer<EndpointItemResponse.Builder> endpointItemResponse) {
            return endpointItemResponse(EndpointItemResponse.builder().applyMutation(endpointItemResponse).build());
        }

        /**
         * <p>
         * A multipart response object that contains a key and a value for each event in the request. In each object,
         * the event ID is the key and an EventItemResponse object is the value.
         * </p>
         * 
         * @param eventsItemResponse
         *        A multipart response object that contains a key and a value for each event in the request. In each
         *        object, the event ID is the key and an EventItemResponse object is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse);
    }

    static final class BuilderImpl implements Builder {
        private EndpointItemResponse endpointItemResponse;

        private Map<String, EventItemResponse> eventsItemResponse = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemResponse model) {
            endpointItemResponse(model.endpointItemResponse);
            eventsItemResponse(model.eventsItemResponse);
        }

        public final EndpointItemResponse.Builder getEndpointItemResponse() {
            return endpointItemResponse != null ? endpointItemResponse.toBuilder() : null;
        }

        public final void setEndpointItemResponse(EndpointItemResponse.BuilderImpl endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse != null ? endpointItemResponse.build() : null;
        }

        @Override
        public final Builder endpointItemResponse(EndpointItemResponse endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse;
            return this;
        }

        public final Map<String, EventItemResponse.Builder> getEventsItemResponse() {
            Map<String, EventItemResponse.Builder> result = MapOfEventItemResponseCopier.copyToBuilder(this.eventsItemResponse);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEventsItemResponse(Map<String, EventItemResponse.BuilderImpl> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copyFromBuilder(eventsItemResponse);
        }

        @Override
        public final Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copy(eventsItemResponse);
            return this;
        }

        @Override
        public ItemResponse build() {
            return new ItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
