/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.pinpoint.PinpointAsyncClient;
import software.amazon.awssdk.services.pinpoint.PinpointServiceClientConfiguration;
import software.amazon.awssdk.services.pinpoint.internal.PinpointServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.ConflictException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysRequest;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PayloadTooLargeException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeletePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetChannelsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetPushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListJourneysRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PhoneNumberValidateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.RemoveAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendOtpMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyStateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateTemplateActiveVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.VerifyOtpMessageRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultPinpointAsyncClient
implements PinpointAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPinpointAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Pinpoint#2.31.77").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createApp$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createApp$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCampaignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCampaignRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createCampaign$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createCampaign$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(CreateEmailTemplateRequest createEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEmailTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createEmailTemplate$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createEmailTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createExportJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createExportJob$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createExportJob$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createImportJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createImportJob$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createImportJob$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInAppTemplateResponse> createInAppTemplate(CreateInAppTemplateRequest createInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInAppTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createInAppTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInAppTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInAppTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateInAppTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInAppTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createInAppTemplate$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createInAppTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJourneyResponse> createJourney(CreateJourneyRequest createJourneyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createJourneyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJourneyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJourney").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateJourneyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createJourneyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createJourney$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createJourney$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePushTemplateResponse> createPushTemplate(CreatePushTemplateRequest createPushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPushTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createPushTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePushTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePushTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePushTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPushTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createPushTemplate$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createPushTemplate$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRecommenderConfigurationResponse> createRecommenderConfiguration(CreateRecommenderConfigurationRequest createRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRecommenderConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRecommenderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRecommenderConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRecommenderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRecommenderConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createRecommenderConfiguration$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createRecommenderConfiguration$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSegmentResponse> createSegment(CreateSegmentRequest createSegmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSegmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSegment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSegmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createSegment$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createSegment$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSmsTemplateResponse> createSmsTemplate(CreateSmsTemplateRequest createSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createSmsTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSmsTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSmsTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSmsTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSmsTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createSmsTemplate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createSmsTemplate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateVoiceTemplateResponse> createVoiceTemplate(CreateVoiceTemplateRequest createVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVoiceTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, createVoiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVoiceTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVoiceTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateVoiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createVoiceTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$createVoiceTemplate$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$createVoiceTemplate$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAdmChannelResponse> deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAdmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAdmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAdmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAdmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteAdmChannel$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteAdmChannel$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApnsChannelResponse> deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApnsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApnsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApnsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApnsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApnsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApnsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteApnsChannel$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteApnsChannel$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApnsSandboxChannelResponse> deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApnsSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApnsSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApnsSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApnsSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApnsSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApnsSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteApnsSandboxChannel$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteApnsSandboxChannel$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApnsVoipChannelResponse> deleteApnsVoipChannel(DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApnsVoipChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApnsVoipChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApnsVoipChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApnsVoipChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApnsVoipChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApnsVoipChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteApnsVoipChannel$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteApnsVoipChannel$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApnsVoipSandboxChannelResponse> deleteApnsVoipSandboxChannel(DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApnsVoipSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApnsVoipSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApnsVoipSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApnsVoipSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApnsVoipSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApnsVoipSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteApnsVoipSandboxChannel$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteApnsVoipSandboxChannel$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteApp$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteApp$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBaiduChannelResponse> deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBaiduChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBaiduChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBaiduChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBaiduChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBaiduChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBaiduChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteBaiduChannel$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteBaiduChannel$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCampaignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCampaignRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteCampaign$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteCampaign$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEmailChannelResponse> deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEmailChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEmailChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEmailChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteEmailChannel$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteEmailChannel$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEmailTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteEmailTemplate$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteEmailTemplate$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteEndpoint$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteEndpoint$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventStreamResponse> deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEventStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEventStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEventStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteEventStream$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteEventStream$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGcmChannelResponse> deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGcmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteGcmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGcmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGcmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteGcmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteGcmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteGcmChannel$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteGcmChannel$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInAppTemplateResponse> deleteInAppTemplate(DeleteInAppTemplateRequest deleteInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInAppTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteInAppTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInAppTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInAppTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteInAppTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInAppTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteInAppTemplate$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteInAppTemplate$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteJourneyResponse> deleteJourney(DeleteJourneyRequest deleteJourneyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteJourneyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJourneyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJourney").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteJourneyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteJourneyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteJourney$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteJourney$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePushTemplateResponse> deletePushTemplate(DeletePushTemplateRequest deletePushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePushTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deletePushTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePushTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePushTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePushTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePushTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deletePushTemplate$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deletePushTemplate$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRecommenderConfigurationResponse> deleteRecommenderConfiguration(DeleteRecommenderConfigurationRequest deleteRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRecommenderConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecommenderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecommenderConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRecommenderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRecommenderConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteRecommenderConfiguration$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteRecommenderConfiguration$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSegmentResponse> deleteSegment(DeleteSegmentRequest deleteSegmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSegmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSegment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSegmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteSegment$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteSegment$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSmsChannelResponse> deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSmsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSmsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSmsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSmsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSmsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSmsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteSmsChannel$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteSmsChannel$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSmsTemplateResponse> deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSmsTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSmsTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSmsTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSmsTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSmsTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteSmsTemplate$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteSmsTemplate$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserEndpointsResponse> deleteUserEndpoints(DeleteUserEndpointsRequest deleteUserEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUserEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteUserEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUserEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteUserEndpoints$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteUserEndpoints$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceChannelResponse> deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVoiceChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteVoiceChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteVoiceChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteVoiceChannel$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteVoiceChannel$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVoiceTemplateResponse> deleteVoiceTemplate(DeleteVoiceTemplateRequest deleteVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVoiceTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, deleteVoiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVoiceTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVoiceTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteVoiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVoiceTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$deleteVoiceTemplate$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$deleteVoiceTemplate$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAdmChannelResponse> getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAdmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getAdmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAdmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAdmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAdmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAdmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getAdmChannel$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getAdmChannel$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApnsChannelResponse> getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApnsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApnsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApnsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApnsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApnsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApnsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApnsChannel$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApnsChannel$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApnsSandboxChannelResponse> getApnsSandboxChannel(GetApnsSandboxChannelRequest getApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApnsSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApnsSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApnsSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApnsSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApnsSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApnsSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApnsSandboxChannel$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApnsSandboxChannel$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApnsVoipChannelResponse> getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApnsVoipChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApnsVoipChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApnsVoipChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApnsVoipChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApnsVoipChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApnsVoipChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApnsVoipChannel$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApnsVoipChannel$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApnsVoipSandboxChannelResponse> getApnsVoipSandboxChannel(GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApnsVoipSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApnsVoipSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApnsVoipSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApnsVoipSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApnsVoipSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApnsVoipSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApnsVoipSandboxChannel$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApnsVoipSandboxChannel$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApp$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApp$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApplicationDateRangeKpiResponse> getApplicationDateRangeKpi(GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApplicationDateRangeKpiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApplicationDateRangeKpiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApplicationDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationDateRangeKpiResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationDateRangeKpi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApplicationDateRangeKpiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApplicationDateRangeKpiRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApplicationDateRangeKpi$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApplicationDateRangeKpi$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApplicationSettingsResponse> getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApplicationSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getApplicationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApplicationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApplicationSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApplicationSettings$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApplicationSettings$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppsResponse> getApps(GetAppsRequest getAppsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getAppsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getApps$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getApps$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBaiduChannelResponse> getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBaiduChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getBaiduChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBaiduChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBaiduChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBaiduChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBaiduChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getBaiduChannel$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getBaiduChannel$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaign$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaign$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignActivitiesResponse> getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignActivitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignActivitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaignActivities$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaignActivities$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignDateRangeKpiResponse> getCampaignDateRangeKpi(GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignDateRangeKpiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignDateRangeKpiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignDateRangeKpiResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignDateRangeKpi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignDateRangeKpiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignDateRangeKpiRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaignDateRangeKpi$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaignDateRangeKpi$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignVersionResponse> getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaignVersion$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaignVersion$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignVersionsResponse> getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaignVersions$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaignVersions$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCampaignsResponse> getCampaigns(GetCampaignsRequest getCampaignsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getCampaignsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaigns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCampaignsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getCampaigns$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getCampaigns$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetChannelsResponse> getChannels(GetChannelsRequest getChannelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getChannelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getChannels$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getChannels$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEmailChannelResponse> getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getEmailChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEmailChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEmailChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getEmailChannel$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getEmailChannel$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEmailTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getEmailTemplate$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getEmailTemplate$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEndpointResponse> getEndpoint(GetEndpointRequest getEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getEndpoint$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getEndpoint$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventStreamResponse> getEventStream(GetEventStreamRequest getEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getEventStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEventStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getEventStream$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getEventStream$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExportJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getExportJob$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getExportJob$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExportJobsResponse> getExportJobs(GetExportJobsRequest getExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExportJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getExportJobs$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getExportJobs$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGcmChannelResponse> getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGcmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getGcmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGcmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGcmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetGcmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getGcmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getGcmChannel$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getGcmChannel$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getImportJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getImportJob$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getImportJob$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetImportJobsResponse> getImportJobs(GetImportJobsRequest getImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getImportJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getImportJobs$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getImportJobs$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInAppMessagesResponse> getInAppMessages(GetInAppMessagesRequest getInAppMessagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInAppMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getInAppMessagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInAppMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInAppMessagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInAppMessages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInAppMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInAppMessagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getInAppMessages$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getInAppMessages$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInAppTemplateResponse> getInAppTemplate(GetInAppTemplateRequest getInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInAppTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getInAppTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInAppTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInAppTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInAppTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInAppTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getInAppTemplate$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getInAppTemplate$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyResponse> getJourney(GetJourneyRequest getJourneyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourney").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourney$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourney$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyDateRangeKpiResponse> getJourneyDateRangeKpi(GetJourneyDateRangeKpiRequest getJourneyDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyDateRangeKpiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyDateRangeKpiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyDateRangeKpiResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyDateRangeKpi").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyDateRangeKpiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyDateRangeKpiRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyDateRangeKpi$258(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyDateRangeKpi$259((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyExecutionActivityMetricsResponse> getJourneyExecutionActivityMetrics(GetJourneyExecutionActivityMetricsRequest getJourneyExecutionActivityMetricsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyExecutionActivityMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyExecutionActivityMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyExecutionActivityMetricsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyExecutionActivityMetrics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyExecutionActivityMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyExecutionActivityMetricsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyExecutionActivityMetrics$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyExecutionActivityMetrics$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyExecutionMetricsResponse> getJourneyExecutionMetrics(GetJourneyExecutionMetricsRequest getJourneyExecutionMetricsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyExecutionMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyExecutionMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyExecutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyExecutionMetricsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyExecutionMetrics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyExecutionMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyExecutionMetricsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyExecutionMetrics$266(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyExecutionMetrics$267((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyRunExecutionActivityMetricsResponse> getJourneyRunExecutionActivityMetrics(GetJourneyRunExecutionActivityMetricsRequest getJourneyRunExecutionActivityMetricsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyRunExecutionActivityMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyRunExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyRunExecutionActivityMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyRunExecutionActivityMetricsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyRunExecutionActivityMetrics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyRunExecutionActivityMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyRunExecutionActivityMetricsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyRunExecutionActivityMetrics$270(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyRunExecutionActivityMetrics$271((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyRunExecutionMetricsResponse> getJourneyRunExecutionMetrics(GetJourneyRunExecutionMetricsRequest getJourneyRunExecutionMetricsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyRunExecutionMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyRunExecutionMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyRunExecutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyRunExecutionMetricsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyRunExecutionMetrics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyRunExecutionMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyRunExecutionMetricsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyRunExecutionMetrics$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyRunExecutionMetrics$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJourneyRunsResponse> getJourneyRuns(GetJourneyRunsRequest getJourneyRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJourneyRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getJourneyRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJourneyRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJourneyRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJourneyRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJourneyRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJourneyRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getJourneyRuns$278(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getJourneyRuns$279((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPushTemplateResponse> getPushTemplate(GetPushTemplateRequest getPushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPushTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getPushTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPushTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPushTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPushTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPushTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getPushTemplate$282(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getPushTemplate$283((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRecommenderConfigurationResponse> getRecommenderConfiguration(GetRecommenderConfigurationRequest getRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRecommenderConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommenderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommenderConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRecommenderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRecommenderConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getRecommenderConfiguration$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getRecommenderConfiguration$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRecommenderConfigurationsResponse> getRecommenderConfigurations(GetRecommenderConfigurationsRequest getRecommenderConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRecommenderConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommenderConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommenderConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommenderConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRecommenderConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRecommenderConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getRecommenderConfigurations$290(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getRecommenderConfigurations$291((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentResponse> getSegment(GetSegmentRequest getSegmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegment$294(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegment$295((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentExportJobsResponse> getSegmentExportJobs(GetSegmentExportJobsRequest getSegmentExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegmentExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentExportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegmentExportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentExportJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegmentExportJobs$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegmentExportJobs$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentImportJobsResponse> getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegmentImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegmentImportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentImportJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegmentImportJobs$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegmentImportJobs$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentVersionResponse> getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegmentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegmentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegmentVersion$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegmentVersion$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentVersionsResponse> getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegmentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegmentVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegmentVersions$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegmentVersions$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSegmentsResponse> getSegments(GetSegmentsRequest getSegmentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSegmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSegmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSegments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSegmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSegments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSegmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSegmentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSegments$314(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSegments$315((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSmsChannelResponse> getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSmsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSmsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSmsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSmsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSmsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSmsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSmsChannel$318(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSmsChannel$319((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSmsTemplateResponse> getSmsTemplate(GetSmsTemplateRequest getSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getSmsTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSmsTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSmsTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSmsTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSmsTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getSmsTemplate$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getSmsTemplate$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserEndpointsResponse> getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getUserEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUserEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getUserEndpoints$326(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getUserEndpoints$327((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceChannelResponse> getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getVoiceChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getVoiceChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetVoiceChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getVoiceChannel$330(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getVoiceChannel$331((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetVoiceTemplateResponse> getVoiceTemplate(GetVoiceTemplateRequest getVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getVoiceTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, getVoiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVoiceTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVoiceTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetVoiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getVoiceTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$getVoiceTemplate$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$getVoiceTemplate$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListJourneysResponse> listJourneys(ListJourneysRequest listJourneysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJourneysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, listJourneysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJourneys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJourneysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJourneys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListJourneysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJourneysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$listJourneys$338(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$listJourneys$339((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$listTagsForResource$342(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$listTagsForResource$343((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(ListTemplateVersionsRequest listTemplateVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTemplateVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplateVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTemplateVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplateVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTemplateVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTemplateVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$listTemplateVersions$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$listTemplateVersions$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, listTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$listTemplates$350(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$listTemplates$351((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PhoneNumberValidateResponse> phoneNumberValidate(PhoneNumberValidateRequest phoneNumberValidateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)phoneNumberValidateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, phoneNumberValidateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PhoneNumberValidate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PhoneNumberValidateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PhoneNumberValidate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PhoneNumberValidateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)phoneNumberValidateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$phoneNumberValidate$354(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$phoneNumberValidate$355((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEventStreamResponse> putEventStream(PutEventStreamRequest putEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, putEventStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEventStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutEventStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEventStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$putEventStream$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$putEventStream$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, putEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$putEvents$362(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$putEvents$363((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveAttributesResponse> removeAttributes(RemoveAttributesRequest removeAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, removeAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$removeAttributes$366(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$removeAttributes$367((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendMessagesResponse> sendMessages(SendMessagesRequest sendMessagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, sendMessagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendMessagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendMessages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendMessagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$sendMessages$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$sendMessages$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendOtpMessageResponse> sendOTPMessage(SendOtpMessageRequest sendOtpMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendOtpMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, sendOtpMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendOTPMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendOtpMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendOTPMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendOtpMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendOtpMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$sendOTPMessage$374(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$sendOTPMessage$375((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendUsersMessagesResponse> sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendUsersMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, sendUsersMessagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendUsersMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendUsersMessagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendUsersMessages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendUsersMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendUsersMessagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$sendUsersMessages$378(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$sendUsersMessages$379((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$tagResource$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$tagResource$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$untagResource$386(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$untagResource$387((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAdmChannelResponse> updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAdmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateAdmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAdmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAdmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAdmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAdmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateAdmChannel$390(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateAdmChannel$391((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApnsChannelResponse> updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApnsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateApnsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApnsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApnsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApnsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApnsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateApnsChannel$394(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateApnsChannel$395((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApnsSandboxChannelResponse> updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApnsSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateApnsSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApnsSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApnsSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApnsSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApnsSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateApnsSandboxChannel$398(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateApnsSandboxChannel$399((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApnsVoipChannelResponse> updateApnsVoipChannel(UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApnsVoipChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateApnsVoipChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApnsVoipChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApnsVoipChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApnsVoipChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApnsVoipChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateApnsVoipChannel$402(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateApnsVoipChannel$403((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApnsVoipSandboxChannelResponse> updateApnsVoipSandboxChannel(UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApnsVoipSandboxChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateApnsVoipSandboxChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApnsVoipSandboxChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApnsVoipSandboxChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApnsVoipSandboxChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApnsVoipSandboxChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateApnsVoipSandboxChannel$406(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateApnsVoipSandboxChannel$407((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationSettingsResponse> updateApplicationSettings(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateApplicationSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApplicationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApplicationSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateApplicationSettings$410(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateApplicationSettings$411((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBaiduChannelResponse> updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBaiduChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateBaiduChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBaiduChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBaiduChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBaiduChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBaiduChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateBaiduChannel$414(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateBaiduChannel$415((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCampaignRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateCampaign$418(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateCampaign$419((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEmailChannelResponse> updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEmailChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateEmailChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEmailChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEmailChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEmailChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEmailChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateEmailChannel$422(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateEmailChannel$423((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEmailTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEmailTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEmailTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEmailTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEmailTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateEmailTemplate$426(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateEmailTemplate$427((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateEndpoint$430(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateEndpoint$431((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointsBatchResponse> updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEndpointsBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateEndpointsBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpointsBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointsBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpointsBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEndpointsBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEndpointsBatchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateEndpointsBatch$434(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateEndpointsBatch$435((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGcmChannelResponse> updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGcmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateGcmChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGcmChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGcmChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGcmChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGcmChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateGcmChannel$438(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateGcmChannel$439((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateInAppTemplateResponse> updateInAppTemplate(UpdateInAppTemplateRequest updateInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInAppTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateInAppTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInAppTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInAppTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateInAppTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateInAppTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateInAppTemplate$442(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateInAppTemplate$443((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJourneyResponse> updateJourney(UpdateJourneyRequest updateJourneyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateJourneyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJourneyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJourney").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateJourneyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJourneyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateJourney$446(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateJourney$447((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJourneyStateResponse> updateJourneyState(UpdateJourneyStateRequest updateJourneyStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJourneyStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateJourneyStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJourneyState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJourneyStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJourneyState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateJourneyStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJourneyStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateJourneyState$450(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateJourneyState$451((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePushTemplateResponse> updatePushTemplate(UpdatePushTemplateRequest updatePushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePushTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updatePushTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePushTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePushTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePushTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePushTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updatePushTemplate$454(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updatePushTemplate$455((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRecommenderConfigurationResponse> updateRecommenderConfiguration(UpdateRecommenderConfigurationRequest updateRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRecommenderConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecommenderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecommenderConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRecommenderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRecommenderConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateRecommenderConfiguration$458(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateRecommenderConfiguration$459((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSegmentResponse> updateSegment(UpdateSegmentRequest updateSegmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateSegmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSegmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSegment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSegmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSegmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateSegment$462(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateSegment$463((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmsChannelResponse> updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmsChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmsChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSmsChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmsChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmsChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateSmsChannel$466(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateSmsChannel$467((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmsTemplateResponse> updateSmsTemplate(UpdateSmsTemplateRequest updateSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmsTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmsTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSmsTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmsTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmsTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateSmsTemplate$470(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateSmsTemplate$471((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTemplateActiveVersionResponse> updateTemplateActiveVersion(UpdateTemplateActiveVersionRequest updateTemplateActiveVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTemplateActiveVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateTemplateActiveVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTemplateActiveVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTemplateActiveVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplateActiveVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTemplateActiveVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTemplateActiveVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateTemplateActiveVersion$474(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateTemplateActiveVersion$475((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVoiceChannelResponse> updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVoiceChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateVoiceChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVoiceChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVoiceChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateVoiceChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVoiceChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateVoiceChannel$478(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateVoiceChannel$479((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVoiceTemplateResponse> updateVoiceTemplate(UpdateVoiceTemplateRequest updateVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVoiceTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, updateVoiceTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVoiceTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVoiceTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateVoiceTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVoiceTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$updateVoiceTemplate$482(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$updateVoiceTemplate$483((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<VerifyOtpMessageResponse> verifyOTPMessage(VerifyOtpMessageRequest verifyOtpMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyOtpMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPinpointAsyncClient.resolveMetricPublishers(clientConfiguration, verifyOtpMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyOTPMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyOtpMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "MethodNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MethodNotAllowedException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(MethodNotAllowedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "PayloadTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PayloadTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(PayloadTooLargeException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyOTPMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new VerifyOtpMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)verifyOtpMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPinpointAsyncClient.lambda$verifyOTPMessage$486(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPinpointAsyncClient.lambda$verifyOTPMessage$487((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final PinpointServiceClientConfiguration serviceClientConfiguration() {
        return new PinpointServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "mobiletargeting";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PinpointException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PinpointServiceClientConfigurationBuilder serviceConfigBuilder = new PinpointServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifyOTPMessage$487(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyOTPMessage$486(List metricPublishers, MetricCollector apiCallMetricCollector, VerifyOtpMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateVoiceTemplate$483(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVoiceTemplate$482(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVoiceTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateVoiceChannel$479(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVoiceChannel$478(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVoiceChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTemplateActiveVersion$475(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTemplateActiveVersion$474(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTemplateActiveVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSmsTemplate$471(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSmsTemplate$470(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmsTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSmsChannel$467(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSmsChannel$466(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSegment$463(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSegment$462(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSegmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRecommenderConfiguration$459(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRecommenderConfiguration$458(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRecommenderConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePushTemplate$455(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePushTemplate$454(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePushTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJourneyState$451(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJourneyState$450(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJourneyStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJourney$447(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJourney$446(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJourneyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateInAppTemplate$443(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInAppTemplate$442(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateInAppTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGcmChannel$439(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGcmChannel$438(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGcmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEndpointsBatch$435(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpointsBatch$434(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEndpointsBatchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEndpoint$431(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpoint$430(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEmailTemplate$427(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEmailTemplate$426(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEmailTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEmailChannel$423(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEmailChannel$422(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEmailChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCampaign$419(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCampaign$418(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCampaignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBaiduChannel$415(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBaiduChannel$414(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBaiduChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApplicationSettings$411(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplicationSettings$410(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApplicationSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApnsVoipSandboxChannel$407(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApnsVoipSandboxChannel$406(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApnsVoipSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApnsVoipChannel$403(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApnsVoipChannel$402(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApnsVoipChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApnsSandboxChannel$399(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApnsSandboxChannel$398(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApnsSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApnsChannel$395(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApnsChannel$394(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApnsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAdmChannel$391(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAdmChannel$390(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAdmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$387(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$386(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$382(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendUsersMessages$379(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendUsersMessages$378(List metricPublishers, MetricCollector apiCallMetricCollector, SendUsersMessagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendOTPMessage$375(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendOTPMessage$374(List metricPublishers, MetricCollector apiCallMetricCollector, SendOtpMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendMessages$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendMessages$370(List metricPublishers, MetricCollector apiCallMetricCollector, SendMessagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeAttributes$367(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAttributes$366(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEvents$363(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEvents$362(List metricPublishers, MetricCollector apiCallMetricCollector, PutEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putEventStream$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEventStream$358(List metricPublishers, MetricCollector apiCallMetricCollector, PutEventStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$phoneNumberValidate$355(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$phoneNumberValidate$354(List metricPublishers, MetricCollector apiCallMetricCollector, PhoneNumberValidateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTemplates$351(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplates$350(List metricPublishers, MetricCollector apiCallMetricCollector, ListTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTemplateVersions$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplateVersions$346(List metricPublishers, MetricCollector apiCallMetricCollector, ListTemplateVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$343(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$342(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJourneys$339(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJourneys$338(List metricPublishers, MetricCollector apiCallMetricCollector, ListJourneysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceTemplate$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceTemplate$334(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getVoiceChannel$331(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVoiceChannel$330(List metricPublishers, MetricCollector apiCallMetricCollector, GetVoiceChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUserEndpoints$327(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserEndpoints$326(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSmsTemplate$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSmsTemplate$322(List metricPublishers, MetricCollector apiCallMetricCollector, GetSmsTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSmsChannel$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSmsChannel$318(List metricPublishers, MetricCollector apiCallMetricCollector, GetSmsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegments$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegments$314(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegmentVersions$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegmentVersions$310(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegmentVersion$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegmentVersion$306(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegmentImportJobs$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegmentImportJobs$302(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentImportJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegmentExportJobs$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegmentExportJobs$298(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentExportJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSegment$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSegment$294(List metricPublishers, MetricCollector apiCallMetricCollector, GetSegmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRecommenderConfigurations$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommenderConfigurations$290(List metricPublishers, MetricCollector apiCallMetricCollector, GetRecommenderConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRecommenderConfiguration$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommenderConfiguration$286(List metricPublishers, MetricCollector apiCallMetricCollector, GetRecommenderConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPushTemplate$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPushTemplate$282(List metricPublishers, MetricCollector apiCallMetricCollector, GetPushTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyRuns$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyRuns$278(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyRunExecutionMetrics$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyRunExecutionMetrics$274(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyRunExecutionMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyRunExecutionActivityMetrics$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyRunExecutionActivityMetrics$270(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyRunExecutionActivityMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyExecutionMetrics$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyExecutionMetrics$266(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyExecutionMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyExecutionActivityMetrics$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyExecutionActivityMetrics$262(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyExecutionActivityMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourneyDateRangeKpi$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourneyDateRangeKpi$258(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyDateRangeKpiResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJourney$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJourney$254(List metricPublishers, MetricCollector apiCallMetricCollector, GetJourneyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInAppTemplate$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInAppTemplate$250(List metricPublishers, MetricCollector apiCallMetricCollector, GetInAppTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInAppMessages$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInAppMessages$246(List metricPublishers, MetricCollector apiCallMetricCollector, GetInAppMessagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getImportJobs$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImportJobs$242(List metricPublishers, MetricCollector apiCallMetricCollector, GetImportJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getImportJob$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImportJob$238(List metricPublishers, MetricCollector apiCallMetricCollector, GetImportJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGcmChannel$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGcmChannel$234(List metricPublishers, MetricCollector apiCallMetricCollector, GetGcmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExportJobs$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportJobs$230(List metricPublishers, MetricCollector apiCallMetricCollector, GetExportJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExportJob$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportJob$226(List metricPublishers, MetricCollector apiCallMetricCollector, GetExportJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEventStream$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventStream$222(List metricPublishers, MetricCollector apiCallMetricCollector, GetEventStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEndpoint$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEndpoint$218(List metricPublishers, MetricCollector apiCallMetricCollector, GetEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEmailTemplate$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailTemplate$214(List metricPublishers, MetricCollector apiCallMetricCollector, GetEmailTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEmailChannel$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEmailChannel$210(List metricPublishers, MetricCollector apiCallMetricCollector, GetEmailChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getChannels$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannels$206(List metricPublishers, MetricCollector apiCallMetricCollector, GetChannelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaigns$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaigns$202(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaignVersions$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignVersions$198(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaignVersion$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignVersion$194(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaignDateRangeKpi$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignDateRangeKpi$190(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignDateRangeKpiResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaignActivities$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignActivities$186(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignActivitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCampaign$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaign$182(List metricPublishers, MetricCollector apiCallMetricCollector, GetCampaignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBaiduChannel$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBaiduChannel$178(List metricPublishers, MetricCollector apiCallMetricCollector, GetBaiduChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApps$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApps$174(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApplicationSettings$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApplicationSettings$170(List metricPublishers, MetricCollector apiCallMetricCollector, GetApplicationSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApplicationDateRangeKpi$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApplicationDateRangeKpi$166(List metricPublishers, MetricCollector apiCallMetricCollector, GetApplicationDateRangeKpiResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApp$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApp$162(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApnsVoipSandboxChannel$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApnsVoipSandboxChannel$158(List metricPublishers, MetricCollector apiCallMetricCollector, GetApnsVoipSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApnsVoipChannel$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApnsVoipChannel$154(List metricPublishers, MetricCollector apiCallMetricCollector, GetApnsVoipChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApnsSandboxChannel$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApnsSandboxChannel$150(List metricPublishers, MetricCollector apiCallMetricCollector, GetApnsSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApnsChannel$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApnsChannel$146(List metricPublishers, MetricCollector apiCallMetricCollector, GetApnsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAdmChannel$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAdmChannel$142(List metricPublishers, MetricCollector apiCallMetricCollector, GetAdmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceTemplate$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceTemplate$138(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVoiceChannel$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVoiceChannel$134(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVoiceChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteUserEndpoints$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserEndpoints$130(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteUserEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSmsTemplate$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSmsTemplate$126(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSmsTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSmsChannel$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSmsChannel$122(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSmsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSegment$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSegment$118(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSegmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRecommenderConfiguration$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRecommenderConfiguration$114(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRecommenderConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePushTemplate$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePushTemplate$110(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePushTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteJourney$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJourney$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteJourneyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInAppTemplate$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInAppTemplate$102(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInAppTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteGcmChannel$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGcmChannel$98(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteGcmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEventStream$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventStream$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEventStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEndpoint$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$90(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEmailTemplate$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailTemplate$86(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEmailTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEmailChannel$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEmailChannel$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEmailChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCampaign$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCampaign$78(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCampaignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBaiduChannel$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBaiduChannel$74(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBaiduChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApp$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApp$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApnsVoipSandboxChannel$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApnsVoipSandboxChannel$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApnsVoipSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApnsVoipChannel$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApnsVoipChannel$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApnsVoipChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApnsSandboxChannel$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApnsSandboxChannel$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApnsSandboxChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApnsChannel$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApnsChannel$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApnsChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAdmChannel$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAdmChannel$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAdmChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createVoiceTemplate$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVoiceTemplate$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateVoiceTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSmsTemplate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSmsTemplate$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSmsTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSegment$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSegment$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSegmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRecommenderConfiguration$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRecommenderConfiguration$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRecommenderConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPushTemplate$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPushTemplate$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePushTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createJourney$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJourney$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateJourneyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInAppTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInAppTemplate$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInAppTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createImportJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createImportJob$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateImportJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createExportJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExportJob$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateExportJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEmailTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEmailTemplate$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEmailTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCampaign$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCampaign$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCampaignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApp$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApp$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

