/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.EventDimensions;
import software.amazon.awssdk.services.pinpoint.model.FilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignEventFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignEventFilter> {
    private static final SdkField<EventDimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimensions").getter(CampaignEventFilter.getter(CampaignEventFilter::dimensions)).setter(CampaignEventFilter.setter(Builder::dimensions)).constructor(EventDimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterType").getter(CampaignEventFilter.getter(CampaignEventFilter::filterTypeAsString)).setter(CampaignEventFilter.setter(Builder::filterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, FILTER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CampaignEventFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EventDimensions dimensions;
    private final String filterType;

    private CampaignEventFilter(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.filterType = builder.filterType;
    }

    public final EventDimensions dimensions() {
        return this.dimensions;
    }

    public final FilterType filterType() {
        return FilterType.fromValue(this.filterType);
    }

    public final String filterTypeAsString() {
        return this.filterType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEventFilter)) {
            return false;
        }
        CampaignEventFilter other = (CampaignEventFilter)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.filterTypeAsString(), other.filterTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignEventFilter").add("Dimensions", (Object)this.dimensions()).add("FilterType", (Object)this.filterTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "FilterType": {
                return Optional.ofNullable(clazz.cast(this.filterTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("FilterType", FILTER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignEventFilter, T> g) {
        return obj -> g.apply((CampaignEventFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EventDimensions dimensions;
        private String filterType;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEventFilter model) {
            this.dimensions(model.dimensions);
            this.filterType(model.filterType);
        }

        public final EventDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(EventDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(EventDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getFilterType() {
            return this.filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public CampaignEventFilter build() {
            return new CampaignEventFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignEventFilter> {
        public Builder dimensions(EventDimensions var1);

        default public Builder dimensions(Consumer<EventDimensions.Builder> dimensions) {
            return this.dimensions((EventDimensions)((EventDimensions.Builder)EventDimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder filterType(String var1);

        public Builder filterType(FilterType var1);
    }
}

