/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendUsersMessagesRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, SendUsersMessagesRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(SendUsersMessagesRequest.getter(SendUsersMessagesRequest::applicationId)).setter(SendUsersMessagesRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<SendUsersMessageRequest> SEND_USERS_MESSAGE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SendUsersMessageRequest").getter(SendUsersMessagesRequest.getter(SendUsersMessagesRequest::sendUsersMessageRequest)).setter(SendUsersMessagesRequest.setter(Builder::sendUsersMessageRequest)).constructor(SendUsersMessageRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendUsersMessageRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, SEND_USERS_MESSAGE_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendUsersMessagesRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final SendUsersMessageRequest sendUsersMessageRequest;

    private SendUsersMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.sendUsersMessageRequest = builder.sendUsersMessageRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final SendUsersMessageRequest sendUsersMessageRequest() {
        return this.sendUsersMessageRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendUsersMessageRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessagesRequest)) {
            return false;
        }
        SendUsersMessagesRequest other = (SendUsersMessagesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.sendUsersMessageRequest(), other.sendUsersMessageRequest());
    }

    public final String toString() {
        return ToString.builder((String)"SendUsersMessagesRequest").add("ApplicationId", (Object)this.applicationId()).add("SendUsersMessageRequest", (Object)this.sendUsersMessageRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "SendUsersMessageRequest": {
                return Optional.ofNullable(clazz.cast(this.sendUsersMessageRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("SendUsersMessageRequest", SEND_USERS_MESSAGE_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessagesRequest, T> g) {
        return obj -> g.apply((SendUsersMessagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private SendUsersMessageRequest sendUsersMessageRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessagesRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.sendUsersMessageRequest(model.sendUsersMessageRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final SendUsersMessageRequest.Builder getSendUsersMessageRequest() {
            return this.sendUsersMessageRequest != null ? this.sendUsersMessageRequest.toBuilder() : null;
        }

        public final void setSendUsersMessageRequest(SendUsersMessageRequest.BuilderImpl sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest != null ? sendUsersMessageRequest.build() : null;
        }

        @Override
        public final Builder sendUsersMessageRequest(SendUsersMessageRequest sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendUsersMessagesRequest build() {
            return new SendUsersMessagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendUsersMessagesRequest> {
        public Builder applicationId(String var1);

        public Builder sendUsersMessageRequest(SendUsersMessageRequest var1);

        default public Builder sendUsersMessageRequest(Consumer<SendUsersMessageRequest.Builder> sendUsersMessageRequest) {
            return this.sendUsersMessageRequest((SendUsersMessageRequest)((SendUsersMessageRequest.Builder)SendUsersMessageRequest.builder().applyMutation(sendUsersMessageRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

