/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfMessageHeaderCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageHeader;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignEmailMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignEmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(CampaignEmailMessage.getter(CampaignEmailMessage::body)).setter(CampaignEmailMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromAddress").getter(CampaignEmailMessage.getter(CampaignEmailMessage::fromAddress)).setter(CampaignEmailMessage.setter(Builder::fromAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()}).build();
    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Headers").getter(CampaignEmailMessage.getter(CampaignEmailMessage::headers)).setter(CampaignEmailMessage.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HTML_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HtmlBody").getter(CampaignEmailMessage.getter(CampaignEmailMessage::htmlBody)).setter(CampaignEmailMessage.setter(Builder::htmlBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlBody").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CampaignEmailMessage.getter(CampaignEmailMessage::title)).setter(CampaignEmailMessage.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, FROM_ADDRESS_FIELD, HEADERS_FIELD, HTML_BODY_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CampaignEmailMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String fromAddress;
    private final List<MessageHeader> headers;
    private final String htmlBody;
    private final String title;

    private CampaignEmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.fromAddress = builder.fromAddress;
        this.headers = builder.headers;
        this.htmlBody = builder.htmlBody;
        this.title = builder.title;
    }

    public final String body() {
        return this.body;
    }

    public final String fromAddress() {
        return this.fromAddress;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<MessageHeader> headers() {
        return this.headers;
    }

    public final String htmlBody() {
        return this.htmlBody;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEmailMessage)) {
            return false;
        }
        CampaignEmailMessage other = (CampaignEmailMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.fromAddress(), other.fromAddress()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.htmlBody(), other.htmlBody()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignEmailMessage").add("Body", (Object)this.body()).add("FromAddress", (Object)this.fromAddress()).add("Headers", this.hasHeaders() ? this.headers() : null).add("HtmlBody", (Object)this.htmlBody()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "FromAddress": {
                return Optional.ofNullable(clazz.cast(this.fromAddress()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "HtmlBody": {
                return Optional.ofNullable(clazz.cast(this.htmlBody()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Body", BODY_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("HtmlBody", HTML_BODY_FIELD);
        map.put("Title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignEmailMessage, T> g) {
        return obj -> g.apply((CampaignEmailMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String fromAddress;
        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private String htmlBody;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEmailMessage model) {
            this.body(model.body);
            this.fromAddress(model.fromAddress);
            this.headers(model.headers);
            this.htmlBody(model.htmlBody);
            this.title(model.title);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (MessageHeader)((MessageHeader.Builder)MessageHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHtmlBody() {
            return this.htmlBody;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        @Override
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public CampaignEmailMessage build() {
            return new CampaignEmailMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignEmailMessage> {
        public Builder body(String var1);

        public Builder fromAddress(String var1);

        public Builder headers(Collection<MessageHeader> var1);

        public Builder headers(MessageHeader ... var1);

        public Builder headers(Consumer<MessageHeader.Builder> ... var1);

        public Builder htmlBody(String var1);

        public Builder title(String var1);
    }
}

